/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib.files;

import com.google.common.base.Preconditions;
import com.zenya.damageindicator.libs.net.insprill.xenlib.ColourUtils;
import com.zenya.damageindicator.libs.net.insprill.xenlib.Conversions;
import com.zenya.damageindicator.libs.net.insprill.xenlib.XenLib;
import com.zenya.damageindicator.libs.net.insprill.xenlib.XenMath;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlFile {
    public static final YamlFile CONFIG = new YamlFile("config.yml");
    private final File file;
    private YamlConfiguration cfg;
    private YamlConfiguration internalCfg = new YamlConfiguration();
    private boolean autoUpdate = true;
    private boolean modifiable = true;
    private boolean isLoaded = false;

    public YamlFile(String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"Name cannot be null or empty");
        name = name.endsWith(".yml") ? name : name + ".yml";
        name = name.replace("/", File.separator).replace("\\", File.separator);
        this.file = new File(XenLib.getPlugin().getDataFolder() + File.separator + name);
        this.writeFileIfNotExists();
        this.reload();
        if (this.autoUpdate) {
            this.initInternalCfg();
        }
    }

    public YamlFile(File file) {
        this.file = file;
        file.getParentFile().mkdirs();
        this.writeFileIfNotExists();
        this.reload();
        if (this.autoUpdate) {
            this.initInternalCfg();
        }
    }

    public YamlFile(InputStreamReader reader) {
        this.file = null;
        this.cfg = new YamlConfiguration();
        this.cfg.load((Reader)reader);
        this.internalCfg = this.cfg;
        this.isLoaded = true;
    }

    public YamlFile setAutoUpdate(boolean autoUpdate) {
        if (autoUpdate && !this.modifiable) {
            this.setModifiable(true);
        }
        this.autoUpdate = autoUpdate;
        return this;
    }

    public YamlFile setModifiable(boolean modifiable) {
        if (!modifiable && this.autoUpdate) {
            this.setAutoUpdate(false);
        }
        this.modifiable = modifiable;
        return this;
    }

    private synchronized void writeFileIfNotExists() {
        if (this.file == null || this.file.exists()) {
            return;
        }
        this.file.getParentFile().mkdirs();
        String from = this.getInternalName(this.file);
        try (InputStream is = XenLib.getPlugin().getResource(from);){
            if (is != null) {
                this.writeToFile(XenLib.getPlugin().getResource(from));
            } else {
                this.file.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean initInternalCfg() {
        String from = this.getInternalName(this.file);
        try (InputStream is = XenLib.getPlugin().getResource(from);){
            if (is == null) return false;
            this.internalCfg = new YamlConfiguration();
            this.internalCfg.load((Reader)new InputStreamReader(is));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private synchronized void writeToFile(InputStream is) {
        if (is == null) {
            return;
        }
        try (FileOutputStream outputStream = new FileOutputStream(this.file);){
            int i;
            StringBuilder fullMessage = new StringBuilder();
            while ((i = is.read()) != -1) {
                fullMessage.append((char)i);
            }
            byte[] strToBytes = fullMessage.toString().getBytes();
            outputStream.write(strToBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void save() {
        if (this.file == null) {
            return;
        }
        try {
            this.cfg.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void reload() {
        if (this.file == null) {
            return;
        }
        if (!this.file.exists()) {
            this.writeFileIfNotExists();
        }
        try {
            this.cfg = new YamlConfiguration();
            this.cfg.load(this.file);
            this.isLoaded = true;
        }
        catch (InvalidConfigurationException e) {
            XenLib.getPlugin().getLogger().severe("Failed to load config file \"" + this.getInternalName(this.file) + "\" as it has syntax errors! Use this website to find them: \"https://www.yamlchecker.com/\". ");
            this.onLoadFailure();
        }
        catch (IOException e) {
            e.printStackTrace();
            XenLib.getPlugin().getLogger().severe("Failed to load config file \"" + this.getInternalName(this.file) + "\"!");
            this.onLoadFailure();
        }
    }

    private void onLoadFailure() {
        this.setAutoUpdate(false);
        this.isLoaded = false;
        if (this.initInternalCfg()) {
            this.cfg = this.internalCfg;
            this.isLoaded = true;
        }
    }

    public synchronized void reset() {
        this.cfg = this.internalCfg;
    }

    private String getInternalName(File file) {
        return file.getAbsolutePath().replace(XenLib.getPlugin().getDataFolder().getAbsolutePath() + File.separator, "").replace(File.separatorChar, '/');
    }

    public String getName() {
        String fileName = this.getFile().getName();
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public boolean contains(String path) {
        return this.cfg.contains(path);
    }

    public boolean isConfigSection(String path) {
        return this.cfg.isConfigurationSection(path);
    }

    public Set<String> getKeys(String path) {
        ConfigurationSection section = this.getConfigSection(path);
        if (section == null) {
            return Collections.emptySet();
        }
        return section.getKeys(false);
    }

    @Nullable
    public Class<?> getDataType(String path) {
        return this.getDataType(path, null);
    }

    @Nullable
    public Class<?> getDataType(String path, Class<?> def) {
        Object obj = this.get(path);
        return obj == null ? def : obj.getClass();
    }

    @Nullable
    public Object get(String path) {
        return this.get(path, this.internalCfg.get(path));
    }

    @Nullable
    public Object get(String path, Object def) {
        this.update(path, def);
        return this.cfg.get(path, def);
    }

    public int getInt(String path) {
        return this.getInt(path, this.internalCfg.getInt(path));
    }

    public int getInt(String path, int def) {
        this.update(path, def);
        return this.cfg.getInt(path, def);
    }

    public long getLong(String path) {
        return this.getLong(path, this.internalCfg.getLong(path));
    }

    public long getLong(String path, long def) {
        this.update(path, def);
        return this.cfg.getLong(path, def);
    }

    public double getDouble(String path) {
        return this.getDouble(path, this.internalCfg.getDouble(path));
    }

    public double getDouble(String path, double def) {
        this.update(path, def);
        return this.cfg.getDouble(path, def);
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, this.internalCfg.getBoolean(path));
    }

    public boolean getBoolean(String path, boolean def) {
        this.update(path, def);
        return Conversions.toBoolean(this.cfg.get(path, (Object)def), def);
    }

    @Nullable
    public String getString(String path) {
        return ColourUtils.format(this.getStringRaw(path));
    }

    @Nullable
    public String getString(String path, String def) {
        return ColourUtils.format(this.getStringRaw(path, def));
    }

    @Nullable
    public String getStringRaw(String path) {
        return this.getStringRaw(path, this.internalCfg.getString(path));
    }

    @Nullable
    public String getStringRaw(String path, String def) {
        this.update(path, def);
        if (this.cfg.get(path) instanceof List) {
            return String.join((CharSequence)"\n", this.cfg.getStringList(path));
        }
        return this.cfg.getString(path, def);
    }

    @NotNull
    public List<String> getStringList(String path) {
        return ColourUtils.format(this.getStringListRaw(path));
    }

    @NotNull
    public List<String> getStringList(String path, List<String> def) {
        return ColourUtils.format(this.getStringListRaw(path, def));
    }

    @NotNull
    public List<String> getStringListRaw(String path) {
        return this.getStringListRaw(path, this.internalCfg.getStringList(path));
    }

    @NotNull
    public List<String> getStringListRaw(String path, List<String> def) {
        if (this.update(path, def)) {
            return def;
        }
        if (this.cfg.get(path) instanceof String) {
            String str = this.cfg.getString(path);
            if (str.contains("\n")) {
                return Arrays.asList(str.split("\n"));
            }
            return new ArrayList<String>(Collections.singletonList(this.cfg.getString(path)));
        }
        return this.cfg.getStringList(path);
    }

    @Nullable
    public List<?> getList(String path) {
        return this.getList(path, null);
    }

    @Nullable
    public List<?> getList(String path, List<?> def) {
        this.update(path, def);
        return this.cfg.getList(path, def);
    }

    public org.bukkit.Color getColour(String path) {
        Matcher hexMatcher = ColourUtils.hexPattern.matcher(this.getString(path));
        if (hexMatcher.find()) {
            return org.bukkit.Color.fromRGB((int)Color.decode(hexMatcher.group()).getRGB());
        }
        int red = this.getInt(path + ".red", 255);
        int green = this.getInt(path + ".green", 255);
        int blue = this.getInt(path + ".blue", 255);
        return org.bukkit.Color.fromRGB((int)XenMath.clamp(red, 0, 255), (int)XenMath.clamp(green, 0, 255), (int)XenMath.clamp(blue, 0, 255));
    }

    @Nullable
    public ConfigurationSection getConfigSection(String path) {
        return this.cfg.getConfigurationSection(path);
    }

    public void clear() {
        this.getKeys("").forEach(key -> this.set((String)key, null));
    }

    private boolean update(String path, Object def) {
        if (!this.contains(path)) {
            this.set(path, def);
            if (this.autoUpdate) {
                this.save();
            }
            return true;
        }
        return false;
    }

    public void set(String path, Object obj) {
        Preconditions.checkArgument((boolean)this.modifiable, (Object)"Cannot set values in a non-modifiable config");
        this.cfg.set(path, obj);
    }

    public String toString() {
        return "YamlFile(file=" + this.getFile() + ", autoUpdate=" + this.isAutoUpdate() + ", modifiable=" + this.isModifiable() + ", isLoaded=" + this.isLoaded() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlFile)) {
            return false;
        }
        YamlFile other = (YamlFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof YamlFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }

    public File getFile() {
        return this.file;
    }

    public YamlConfiguration getCfg() {
        return this.cfg;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }
}

