/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib.files;

import com.zenya.damageindicator.libs.net.insprill.xenlib.XenLib;
import com.zenya.damageindicator.libs.net.insprill.xenlib.files.YamlFile;
import java.io.File;
import java.io.IOException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.Nullable;

public class YamlFolder {
    public static final YamlFolder LOCALE = new YamlFolder("locale");
    private final Map<String, YamlFile> dataFiles = new HashMap<String, YamlFile>();
    private final String folderName;
    private final File folder;
    private final boolean autoUpdate;

    public YamlFolder(String folderName) {
        this(folderName, true);
    }

    public YamlFolder(String folderName, boolean autoUpdate) {
        this.folderName = folderName.replace("/", File.separator).replace("\\", File.separator);
        this.autoUpdate = autoUpdate;
        File dir = XenLib.getPlugin().getDataFolder();
        this.folder = new File(dir.getAbsolutePath() + File.separator + folderName);
        this.init();
    }

    private void writeToDisk() {
        try {
            CodeSource src = XenLib.getPlugin().getClass().getProtectionDomain().getCodeSource();
            if (src == null) {
                XenLib.getPlugin().getLogger().warning("Failed to find plugin's jar file. Unable to load all default files.");
                return;
            }
            try (ZipInputStream zip = new ZipInputStream(src.getLocation().openStream());){
                ZipEntry e;
                while ((e = zip.getNextEntry()) != null) {
                    this.initDefaultFile(e.getName());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initDefaultFile(String name) {
        if (!this.isYamlFile(name)) {
            return;
        }
        if (!name.startsWith(this.folderName)) {
            return;
        }
        if (!name.contains("/") && !name.contains("\\")) {
            return;
        }
        File file = new File(XenLib.getPlugin().getDataFolder(), name);
        if (file.isDirectory()) {
            return;
        }
        YamlFile config = new YamlFile(file).setAutoUpdate(true);
        this.dataFiles.put(config.getFile().getAbsolutePath(), config);
    }

    private void init() {
        if (!this.folder.exists() || !this.folder.isDirectory()) {
            this.folder.mkdirs();
        }
        if (this.folder.listFiles().length == 0) {
            this.writeToDisk();
        } else {
            this.initExisting();
        }
    }

    public void reload() {
        this.dataFiles.clear();
        this.init();
    }

    public YamlFile createFile(String name) {
        YamlFile config = new YamlFile(this.folderName + File.separator + name);
        this.dataFiles.put(config.getFile().getAbsolutePath(), config);
        return config;
    }

    private void initExisting() {
        for (File sub : YamlFolder.getNestedFiles(this.folder)) {
            if (!this.isYamlFile(sub.getName())) continue;
            this.dataFiles.put(sub.getAbsolutePath(), new YamlFile(sub).setAutoUpdate(this.autoUpdate));
        }
    }

    private boolean isYamlFile(String fileName) {
        if (!fileName.contains(".")) {
            return false;
        }
        return fileName.substring(fileName.lastIndexOf(46)).toLowerCase(Locale.ROOT).equals(".yml");
    }

    public boolean contains(String name) {
        return this.getDataFile(name) != null;
    }

    @Nullable
    public YamlFile getDataFile(String name) {
        String path;
        name = (name = name.replace("/", File.separator)).startsWith(path = XenLib.getPlugin().getDataFolder().getAbsolutePath() + File.separator + this.folderName + File.separator + name) ? name : path;
        name = name.endsWith(".yml") ? name : name + ".yml";
        return this.dataFiles.get(name);
    }

    @Nullable
    public YamlFile getDataFile(File file) {
        return this.getDataFile(file.getAbsolutePath());
    }

    public Collection<YamlFile> getDataFiles() {
        return this.dataFiles.values();
    }

    private static List<File> getNestedFiles(File root) {
        ArrayList<File> fileNames = new ArrayList<File>();
        for (File f : root.listFiles()) {
            if (f.isDirectory()) {
                fileNames.addAll(YamlFolder.getNestedFiles(f));
                continue;
            }
            fileNames.add(f);
        }
        return fileNames;
    }

    public String toString() {
        return "YamlFolder(folder=" + this.folder + ", autoUpdate=" + this.autoUpdate + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlFolder)) {
            return false;
        }
        YamlFolder other = (YamlFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$folder = this.folder;
        File other$folder = other.folder;
        return !(this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof YamlFolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $folder = this.folder;
        result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
        return result;
    }
}

