/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.nms;

import com.zenya.damageindicator.DamageIndicator;
import com.zenya.damageindicator.libs.net.insprill.spigotutils.MinecraftVersion;
import com.zenya.damageindicator.nms.ProtocolNMS;

public class CompatibilityHandler {
    private static final String FULLY_QUALIFIED_PATH = "com.zenya.damageindicator.nms.%s.ProtocolNMSImpl";

    public static Class<? extends ProtocolNMS> getProtocolNMS() throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = CompatibilityHandler.getNMSClass();
        }
        catch (Exception exc) {
            DamageIndicator.INSTANCE.getLogger().warning("You are running DamageIndicator on an unsupported version (" + MinecraftVersion.getCurrentVersion().getDisplayName() + ")");
            DamageIndicator.INSTANCE.getLogger().warning("Some features may be disabled or broken, and expect degraded performance.");
            clazz = Class.forName(String.format(FULLY_QUALIFIED_PATH, "fallback"));
        }
        return clazz;
    }

    static Class<?> getNMSClass() throws ClassNotFoundException {
        String version = MinecraftVersion.isOlderThan(MinecraftVersion.v1_20_5) ? (MinecraftVersion.is(MinecraftVersion.v1_17_0) ? "v1_17_R0" : MinecraftVersion.getCraftBukkitVersion()) : "v" + MinecraftVersion.getCurrentVersion().getDisplayName(true).replace(".", "_");
        return Class.forName(String.format(FULLY_QUALIFIED_PATH, version));
    }
}

