/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.nms;

import com.zenya.damageindicator.DamageIndicator;
import com.zenya.damageindicator.storage.StorageFileManager;
import com.zenya.damageindicator.storage.ToggleManager;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public interface Hologram {
    public Hologram spawn(double var1, double var3, double var5, double var7, long var9);

    public void sendCreatePacket();

    public void sendMetaPacket();

    public void sendTeleportPacket(Location var1);

    public void sendRemovePacket();

    public void sendPacketToTracked(Object var1);

    public void sendPacketToWorld(Object var1);

    default public void sendPacketIfToggled(UUID uuid, Object connection, Object packet) {
        if (ToggleManager.INSTANCE.isToggled(uuid).booleanValue()) {
            this.sendPacket(connection, packet);
        }
    }

    public void sendPacket(Object var1, Object var2);

    public static class HologramRunnable
    extends BukkitRunnable {
        private final Hologram hologram;
        private final Entity entity;
        private final Location loc;
        private final double offsetX;
        private final double offsetZ;
        private final double startY;
        private final boolean relative;
        private final double speed;
        private final double duration;
        private int tick;
        private double dy;

        public HologramRunnable(Hologram hologram, Entity entity, double offsetX, double offsetY, double offsetZ, double speed, double duration) {
            this.hologram = hologram;
            this.entity = entity;
            this.offsetX = offsetX;
            this.offsetZ = offsetZ;
            this.loc = entity.getLocation().add(offsetX, offsetY, offsetZ);
            this.startY = this.loc.getY() - offsetY;
            this.relative = StorageFileManager.getConfig().getBool("relative-holograms");
            this.speed = speed;
            this.duration = duration;
            this.dy = offsetY;
        }

        public void run() {
            if (this.relative) {
                this.entity.getLocation(this.loc).add(this.offsetX, 0.0, this.offsetZ);
            }
            this.loc.setY(this.startY + this.dy);
            this.hologram.sendTeleportPacket(this.loc);
            this.dy += this.speed;
            ++this.tick;
            if ((double)this.tick > this.duration) {
                this.hologram.sendRemovePacket();
                this.cancel();
            }
        }

        public void start() {
            this.runTaskTimer((Plugin)DamageIndicator.INSTANCE, 0L, 1L);
        }
    }
}

