/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.nms.v1_10_R1;

import com.zenya.damageindicator.nms.Hologram;
import com.zenya.damageindicator.nms.ProtocolNMS;
import net.minecraft.server.v1_10_R1.EntityArmorStand;
import net.minecraft.server.v1_10_R1.EntityHuman;
import net.minecraft.server.v1_10_R1.EntityLiving;
import net.minecraft.server.v1_10_R1.EntityPlayer;
import net.minecraft.server.v1_10_R1.EntityTrackerEntry;
import net.minecraft.server.v1_10_R1.Packet;
import net.minecraft.server.v1_10_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_10_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_10_R1.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_10_R1.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_10_R1.PlayerConnection;
import net.minecraft.server.v1_10_R1.World;
import net.minecraft.server.v1_10_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_10_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ProtocolNMSImpl
implements ProtocolNMS {
    @Override
    public Hologram getHologram(LivingEntity ent, Location loc, String text) {
        return new HologramImpl(ent, loc, text);
    }

    public static class HologramImpl
    implements Hologram {
        private final EntityArmorStand armorStand;
        private final LivingEntity entity;
        private final EntityTrackerEntry tracker;
        private final WorldServer world;

        public HologramImpl(LivingEntity entity, Location loc, String text) {
            this.entity = entity;
            this.world = ((CraftWorld)loc.getWorld()).getHandle();
            this.armorStand = new EntityArmorStand((World)this.world, loc.getX(), loc.getY(), loc.getZ());
            this.armorStand.setInvisible(true);
            this.armorStand.setMarker(true);
            this.armorStand.setSmall(true);
            this.armorStand.setNoGravity(true);
            this.armorStand.setCustomName(text);
            this.armorStand.setCustomNameVisible(true);
            this.tracker = (EntityTrackerEntry)this.world.tracker.trackedEntities.get(entity.getEntityId());
        }

        @Override
        public Hologram spawn(double offsetX, double offsetY, double offsetZ, double speed, long duration) {
            this.sendCreatePacket();
            this.sendMetaPacket();
            new Hologram.HologramRunnable(this, (Entity)this.entity, offsetX, offsetY, offsetZ, speed, duration).start();
            return this;
        }

        @Override
        public void sendCreatePacket() {
            PacketPlayOutSpawnEntityLiving create = new PacketPlayOutSpawnEntityLiving((EntityLiving)this.armorStand);
            this.sendPacketToTracked(create);
        }

        @Override
        public void sendMetaPacket() {
            PacketPlayOutEntityMetadata meta = new PacketPlayOutEntityMetadata(this.armorStand.getId(), this.armorStand.getDataWatcher(), true);
            this.sendPacketToTracked(meta);
        }

        @Override
        public void sendTeleportPacket(Location loc) {
            this.armorStand.setPosition(loc.getX(), loc.getY(), loc.getZ());
            PacketPlayOutEntityTeleport teleport = new PacketPlayOutEntityTeleport((net.minecraft.server.v1_10_R1.Entity)this.armorStand);
            this.sendPacketToTracked(teleport);
        }

        @Override
        public void sendRemovePacket() {
            PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getId()});
            this.sendPacketToWorld(remove);
        }

        @Override
        public void sendPacketToTracked(Object packet) {
            for (EntityHuman conn : this.tracker != null ? this.tracker.trackedPlayers : this.world.players) {
                if (!(conn instanceof EntityPlayer)) continue;
                this.sendPacketIfToggled(conn.getUniqueID(), ((EntityPlayer)conn).playerConnection, packet);
            }
        }

        @Override
        public void sendPacketToWorld(Object packet) {
            for (Player player : this.entity.getWorld().getPlayers()) {
                this.sendPacketIfToggled(player.getUniqueId(), ((CraftPlayer)player).getHandle().playerConnection, packet);
            }
        }

        @Override
        public void sendPacket(Object connection, Object packet) {
            ((PlayerConnection)connection).sendPacket((Packet)packet);
        }
    }
}

