/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator;

import com.zenya.damageindicator.command.ReloadArg;
import com.zenya.damageindicator.event.Listeners;
import com.zenya.damageindicator.libs.net.insprill.spigotutils.MinecraftVersion;
import com.zenya.damageindicator.libs.net.insprill.spigotutils.ServerEnvironment;
import com.zenya.damageindicator.libs.net.insprill.xenlib.XenLib;
import com.zenya.damageindicator.libs.net.insprill.xenlib.commands.Command;
import com.zenya.damageindicator.libs.net.insprill.xenlib.files.YamlFile;
import com.zenya.damageindicator.libs.net.insprill.xenlib.files.YamlFolder;
import com.zenya.damageindicator.libs.org.bstats.bukkit.Metrics;
import com.zenya.damageindicator.nms.CompatibilityHandler;
import com.zenya.damageindicator.nms.ProtocolNMS;
import com.zenya.damageindicator.scoreboard.HealthIndicator;
import com.zenya.damageindicator.storage.StorageFileManager;
import com.zenya.damageindicator.storage.ToggleManager;
import com.zenya.damageindicator.util.BukkitScheduler;
import com.zenya.damageindicator.util.MessagesMigrator;
import com.zenya.damageindicator.util.Scheduler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DamageIndicator
extends JavaPlugin {
    private static final int BSTATS_ID = 15403;
    public static DamageIndicator INSTANCE;
    public static ProtocolNMS PROTOCOL_NMS;
    public static Scheduler SCHEDULER;

    public void onEnable() {
        INSTANCE = this;
        new Metrics((Plugin)this, 15403);
        XenLib.init(this);
        MessagesMigrator.migrate(this);
        boolean fixedAnyLangFiles = false;
        for (YamlFile langFile : YamlFolder.LOCALE.getDataFiles()) {
            Path path = langFile.getFile().toPath();
            try {
                boolean hasSyntaxError = false;
                List<String> contents = Files.readAllLines(path, StandardCharsets.UTF_8);
                for (int i = 0; i < contents.size(); ++i) {
                    String content = contents.get(i);
                    if (!content.contains("\u00e2\u009d\u00a4")) continue;
                    contents.set(i, content.replace("\u00e2\u009d\u00a4", "\\u2764"));
                    hasSyntaxError = true;
                    fixedAnyLangFiles = true;
                }
                if (!hasSyntaxError) continue;
                Files.write(path, contents, StandardCharsets.UTF_8, new OpenOption[0]);
                this.getLogger().info("Fixed syntax error in " + langFile.getName() + ".yml");
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to fix syntax error in " + path + " (" + e.getMessage() + "). Please inspect the file and correct any syntax errors manually");
            }
        }
        if (fixedAnyLangFiles) {
            this.getLogger().info("Reloading lang files");
            YamlFolder.LOCALE.reload();
        }
        StorageFileManager.INSTANCE.reloadFiles();
        if (MinecraftVersion.isOlderThan(MinecraftVersion.v1_8_0)) {
            this.getLogger().severe("DamageIndicator does not support pre-1.8 versions of Minecraft!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            SCHEDULER = ServerEnvironment.isPaper() ? (Scheduler)Class.forName("net.insprill.damageindicator.util.PaperScheduler").getConstructor(new Class[0]).newInstance(new Object[0]) : new BukkitScheduler();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            PROTOCOL_NMS = (ProtocolNMS)CompatibilityHandler.getProtocolNMS().getConstructors()[0].newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)new Listeners(), (Plugin)this);
        SCHEDULER.runDelayed((Plugin)this, () -> new Command("damageindicator", ReloadArg.class.getPackage().getName()), 10L);
        HealthIndicator.INSTANCE.reload();
        for (Player player : Bukkit.getOnlinePlayers()) {
            ToggleManager.INSTANCE.isToggled(player.getUniqueId());
        }
    }

    public void onDisable() {
        if (StorageFileManager.getDatabase() != null) {
            StorageFileManager.getDatabase().shutdown();
        }
        HandlerList.unregisterAll((Plugin)INSTANCE);
    }
}

