/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib;

import com.zenya.damageindicator.libs.net.insprill.xenlib.XenMath;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public final class VectorUtils {
    public static Vector getEntityForward(Entity entity) {
        Vector direction = VectorUtils.getDirectionNormalized(entity);
        return new Vector(direction.getX(), 0.0, direction.getZ());
    }

    public static Vector getEntityBackward(Entity entity) {
        Vector direction = VectorUtils.getDirectionNormalized(entity);
        return new Vector(-direction.getX(), 0.0, -direction.getZ());
    }

    public static Vector getEntityRight(Entity entity) {
        Vector direction = VectorUtils.getDirectionNormalized(entity);
        return new Vector(-direction.getZ(), 0.0, direction.getX()).normalize();
    }

    public static Vector getEntityLeft(Entity entity) {
        Vector direction = VectorUtils.getDirectionNormalized(entity);
        return new Vector(direction.getZ(), 0.0, -direction.getX()).normalize();
    }

    public static Vector getDirectionTo(Entity from, Entity to) {
        if (from.getWorld() != to.getWorld()) {
            return new Vector();
        }
        return to.getLocation().toVector().subtract(from.getLocation().toVector()).normalize();
    }

    private static Vector getDirectionNormalized(Entity entity) {
        Location loc = entity instanceof LivingEntity ? ((LivingEntity)entity).getEyeLocation() : entity.getLocation();
        return loc.getDirection().normalize();
    }

    public static Vector clamp(Vector vector, double min, double max) {
        return new Vector(XenMath.clamp(vector.getX(), min, max), XenMath.clamp(vector.getY(), min, max), XenMath.clamp(vector.getZ(), min, max));
    }

    private VectorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

