/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib.commands;

import com.zenya.damageindicator.libs.net.insprill.xenlib.ClassUtils;
import com.zenya.damageindicator.libs.net.insprill.xenlib.XenLib;
import com.zenya.damageindicator.libs.net.insprill.xenlib.XenUtils;
import com.zenya.damageindicator.libs.net.insprill.xenlib.commands.ICommandArgument;
import com.zenya.damageindicator.libs.net.insprill.xenlib.commands.args.XenLibArgHelp;
import com.zenya.damageindicator.libs.net.insprill.xenlib.commands.args.XenLibArgPlInfo;
import com.zenya.damageindicator.libs.net.insprill.xenlib.localization.Lang;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Command
implements TabExecutor {
    public static final String NO_ARG = "NO_ARG";
    private final Map<String, ICommandArgument> commandArgs = new HashMap<String, ICommandArgument>();
    private int commandsPerPage = 7;

    public Command(String name, String packageName) {
        PluginCommand command = XenLib.getPlugin().getCommand(name);
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
        HashSet<Class<ICommandArgument>> classes = new HashSet<Class<ICommandArgument>>(ClassUtils.getImplementingClasses(packageName, ICommandArgument.class));
        classes.addAll(Arrays.asList(XenLibArgHelp.class, XenLibArgPlInfo.class));
        for (Class clazz : classes) {
            ICommandArgument arg = null;
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterCount() == 0) {
                    arg = (ICommandArgument)constructor.newInstance(new Object[0]);
                    continue;
                }
                if (constructor.getParameterCount() != 1 || constructor.getParameterTypes()[0] != Command.class) continue;
                arg = (ICommandArgument)constructor.newInstance(this);
            }
            if (arg == null) continue;
            this.registerCommand(arg);
        }
    }

    public void registerCommand(ICommandArgument arg) {
        if (this.commandArgs.containsKey(arg.getBaseArg())) {
            new IllegalArgumentException("Tried to register arg " + arg.getBaseArg() + " to " + arg.getClass().getSimpleName() + " but it is already registered to " + this.commandArgs.get(arg.getBaseArg()).getClass().getSimpleName()).printStackTrace();
            return;
        }
        XenUtils.registerPermission(arg.getPermission());
        this.commandArgs.put(arg.getBaseArg().toLowerCase(Locale.ENGLISH), arg);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String label, @NotNull String[] args) {
        ICommandArgument arg;
        ICommandArgument iCommandArgument = arg = args.length == 0 ? this.commandArgs.get(NO_ARG) : this.commandArgs.get(args[0].toLowerCase(Locale.ENGLISH));
        if (arg == null) {
            Lang.send(sender, "commands.unknown-command", "%label%;" + label);
            return true;
        }
        if (!Command.hasPermission(sender, arg)) {
            Lang.send(sender, "commands.no-permission", new String[0]);
            return true;
        }
        if (!(sender instanceof Player) && arg.isPlayerOnly()) {
            Lang.send(sender, "commands.player-only", new String[0]);
            return true;
        }
        boolean valid = arg.process(sender, label, args);
        if (!valid) {
            Lang.send(sender, "commands.invalid-usage", "%label%;" + label);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String alias, @NotNull String[] args) {
        List<String> completions;
        if (args.length == 1) {
            completions = this.commandArgs.keySet().parallelStream().filter(e -> Command.hasPermission(sender, this.commandArgs.get(e))).filter(e -> !e.equals(NO_ARG)).collect(Collectors.toList());
        } else {
            ICommandArgument arg = this.commandArgs.get(args[0].toLowerCase(Locale.ENGLISH));
            if (arg == null) {
                return Collections.emptyList();
            }
            if (!Command.hasPermission(sender, arg)) {
                return Collections.emptyList();
            }
            if (arg.isPlayerOnly() && !(sender instanceof Player)) {
                return Collections.emptyList();
            }
            completions = arg.tabComplete(sender, args);
            if (completions == null) {
                completions = Collections.emptyList();
            }
        }
        completions = (List<String>)StringUtil.copyPartialMatches((String)args[args.length - 1], completions, new ArrayList());
        Collections.sort(completions);
        return completions;
    }

    public static boolean hasPermission(CommandSender sender, ICommandArgument arg) {
        String perm = arg.getPermission();
        if (perm == null || perm.isEmpty()) {
            return true;
        }
        return perm.equals("op") ? sender.isOp() : sender.hasPermission(perm);
    }

    public Map<String, ICommandArgument> getCommandArgs() {
        return this.commandArgs;
    }

    public int getCommandsPerPage() {
        return this.commandsPerPage;
    }

    public void setCommandsPerPage(int commandsPerPage) {
        this.commandsPerPage = commandsPerPage;
    }
}

