/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib.commands.args;

import com.zenya.damageindicator.libs.net.insprill.xenlib.ColourUtils;
import com.zenya.damageindicator.libs.net.insprill.xenlib.XenLib;
import com.zenya.damageindicator.libs.net.insprill.xenlib.XenMath;
import com.zenya.damageindicator.libs.net.insprill.xenlib.commands.Command;
import com.zenya.damageindicator.libs.net.insprill.xenlib.commands.ICommandArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XenLibArgHelp
implements ICommandArgument {
    private final Command cmd;
    private int commandsPerPage = 7;

    public XenLibArgHelp(Command cmd) {
        this.cmd = cmd;
    }

    @Override
    public String getBaseArg() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Shows all commands, their arguments, and what they do.";
    }

    @Override
    @Nullable
    public String getPermission() {
        return null;
    }

    @Override
    public boolean process(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        int i;
        long page = args.length >= 2 && XenMath.isInteger(args[1]) ? (long)Integer.parseInt(args[1]) : 1L;
        page = XenMath.clamp(page, 1L, (long)this.getPageCount());
        String header = this.getPageCount() == 1 ? ColourUtils.format("&e===========< &6Help &e>===========") : ColourUtils.format("&e=======< &6Help &e- &6Page " + page + " &e>=======");
        sender.sendMessage(header);
        List argEntries = this.cmd.getCommandArgs().entrySet().stream().skip((long)this.commandsPerPage * (page - 1L)).limit(this.commandsPerPage).filter(x -> !((String)x.getKey()).equals("NO_ARG")).filter(x -> Command.hasPermission(sender, (ICommandArgument)x.getValue())).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        for (Map.Entry entry : argEntries) {
            ICommandArgument argument = (ICommandArgument)entry.getValue();
            if (argument.isPlayerOnly() && !(sender instanceof Player)) continue;
            StringBuilder argumentBuilder = new StringBuilder();
            argumentBuilder.append("&2/").append(label).append(" ").append((String)entry.getKey());
            for (Map.Entry<String, Boolean> argEntry : argument.getSubArgs().entrySet()) {
                boolean optional = argEntry.getValue();
                argumentBuilder.append(" ");
                argumentBuilder.append(optional ? "&7(" : "&8[");
                argumentBuilder.append(argEntry.getKey());
                argumentBuilder.append(optional ? ")" : "]");
            }
            argumentBuilder.append(" &f- &a").append(((ICommandArgument)entry.getValue()).getDescription());
            sender.sendMessage(ColourUtils.format(argumentBuilder.toString()));
        }
        int fillerLength = ChatColor.stripColor((String)header).length() - (XenLib.getPlugin().getName().length() + 4);
        StringBuilder footerBuilder = new StringBuilder();
        footerBuilder.append("&e");
        for (i = 0; i < fillerLength >> 1; ++i) {
            footerBuilder.append("=");
        }
        footerBuilder.append("< &6").append(XenLib.getPlugin().getName()).append(" &e>");
        for (i = 0; i < fillerLength >> 1; ++i) {
            footerBuilder.append("=");
        }
        sender.sendMessage(ColourUtils.format(footerBuilder.toString()));
        return true;
    }

    private int getPageCount() {
        return (int)Math.ceil((float)this.cmd.getCommandArgs().size() / (float)this.commandsPerPage);
    }

    @Override
    @Nullable
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length != 2) {
            return Collections.emptyList();
        }
        ArrayList<String> returnArgs = new ArrayList<String>();
        for (int i = 1; i <= this.getPageCount(); ++i) {
            returnArgs.add(i + "");
        }
        return returnArgs;
    }

    public int getCommandsPerPage() {
        return this.commandsPerPage;
    }

    public void setCommandsPerPage(int commandsPerPage) {
        this.commandsPerPage = commandsPerPage;
    }
}

