/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.nms;

import com.zenya.damageindicator.DamageIndicator;
import com.zenya.damageindicator.libs.net.insprill.spigotutils.MinecraftVersion;
import com.zenya.damageindicator.libs.net.insprill.spigotutils.ServerEnvironment;
import com.zenya.damageindicator.nms.ProtocolNMS;

public class CompatibilityHandler {
    private static final String FULLY_QUALIFIED_PATH = "com.zenya.damageindicator.nms.%s.ProtocolNMSImpl";

    public static Class<? extends ProtocolNMS> getProtocolNMS() throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = CompatibilityHandler.getNMSClass();
        }
        catch (Exception exc) {
            DamageIndicator.INSTANCE.getLogger().warning("You are running DamageIndicator on an unsupported version (" + MinecraftVersion.getCurrentVersion().getDisplayName() + ")");
            DamageIndicator.INSTANCE.getLogger().warning("Some features may be disabled or broken, and expect degraded performance.");
            clazz = CompatibilityHandler.getFallbackClass();
        }
        return clazz;
    }

    static Class<?> getNMSClass() throws ClassNotFoundException {
        if (!ServerEnvironment.isPaper() && MinecraftVersion.isAtLeast(MinecraftVersion.v1_21_3)) {
            DamageIndicator.INSTANCE.getLogger().warning("The high performance implementation is no longer supported on Spigot!");
            DamageIndicator.INSTANCE.getLogger().warning("Please switch to Paper, or downgrade Damage Indicator.");
            DamageIndicator.INSTANCE.getLogger().warning("Expect degraded performance in this state.");
            return CompatibilityHandler.getFallbackClass();
        }
        String version = MinecraftVersion.isOlderThan(MinecraftVersion.v1_20_5) ? (MinecraftVersion.is(MinecraftVersion.v1_17_0) ? "v1_17_R0" : MinecraftVersion.getCraftBukkitVersion()) : "v" + MinecraftVersion.getCurrentVersion().getDisplayName(true).replace(".", "_");
        return Class.forName(String.format(FULLY_QUALIFIED_PATH, version));
    }

    static Class<?> getFallbackClass() throws ClassNotFoundException {
        return Class.forName(String.format(FULLY_QUALIFIED_PATH, "fallback"));
    }
}

