/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.nms;

import com.zenya.damageindicator.DamageIndicator;
import com.zenya.damageindicator.storage.StorageFileManager;
import com.zenya.damageindicator.util.Scheduler;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public interface Hologram {
    public Hologram spawn(double var1, double var3, double var5, double var7, long var9);

    public void sendCreatePacket();

    public void sendMetaPacket();

    public void sendTeleportPacket(Location var1);

    public void sendRemovePacket();

    public static class HologramRunnable
    implements Runnable {
        private final Hologram hologram;
        private final Entity entity;
        private final Location loc;
        private final double offsetX;
        private final double offsetZ;
        private final double startY;
        private final boolean relative;
        private final double speed;
        private final double duration;
        private int tick;
        private double dy;
        private Scheduler.CancelableTask task;

        public HologramRunnable(Hologram hologram, Entity entity, double offsetX, double offsetY, double offsetZ, double speed, double duration) {
            this.hologram = hologram;
            this.entity = entity;
            this.offsetX = offsetX;
            this.offsetZ = offsetZ;
            this.loc = entity.getLocation().add(offsetX, offsetY, offsetZ);
            this.startY = this.loc.getY() - offsetY;
            this.relative = StorageFileManager.getConfig().getBool("relative-holograms");
            this.speed = speed;
            this.duration = duration;
            this.dy = offsetY;
        }

        @Override
        public void run() {
            if (this.relative) {
                this.entity.getLocation(this.loc).add(this.offsetX, 0.0, this.offsetZ);
            }
            this.loc.setY(this.startY + this.dy);
            this.hologram.sendTeleportPacket(this.loc);
            this.dy += this.speed;
            ++this.tick;
            if ((double)this.tick > this.duration) {
                this.hologram.sendRemovePacket();
                this.task.cancel();
            }
        }

        public void start() {
            this.task = DamageIndicator.SCHEDULER.runAtFixedRate((Plugin)DamageIndicator.INSTANCE, this, 0L, 1L);
        }
    }
}

