/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.nms.v1_17_R0;

import com.zenya.damageindicator.nms.Hologram;
import com.zenya.damageindicator.nms.ProtocolNMS;
import java.util.List;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ProtocolNMSImpl
implements ProtocolNMS {
    @Override
    public Hologram getHologram(LivingEntity ent, Location loc, List<Player> players, String text) {
        return new HologramImpl(ent, loc, players, text);
    }

    public static class HologramImpl
    implements Hologram {
        private final EntityArmorStand armorStand;
        private final LivingEntity entity;
        private final List<Player> players;

        public HologramImpl(LivingEntity entity, Location loc, List<Player> players, String text) {
            this.entity = entity;
            this.players = players;
            WorldServer world = ((CraftWorld)loc.getWorld()).getHandle();
            this.armorStand = new EntityArmorStand((World)world, loc.getX(), loc.getY(), loc.getZ());
            this.armorStand.setInvisible(true);
            this.armorStand.setMarker(true);
            this.armorStand.setSmall(true);
            this.armorStand.setNoGravity(true);
            this.armorStand.setCustomName((IChatBaseComponent)new ChatComponentText(text));
            this.armorStand.setCustomNameVisible(true);
        }

        @Override
        public Hologram spawn(double offsetX, double offsetY, double offsetZ, double speed, long duration) {
            this.sendCreatePacket();
            this.sendMetaPacket();
            new Hologram.HologramRunnable(this, (Entity)this.entity, offsetX, offsetY, offsetZ, speed, duration).start();
            return this;
        }

        @Override
        public void sendCreatePacket() {
            PacketPlayOutSpawnEntityLiving create = new PacketPlayOutSpawnEntityLiving((EntityLiving)this.armorStand);
            this.sendPacket((Packet<?>)create);
        }

        @Override
        public void sendMetaPacket() {
            PacketPlayOutEntityMetadata meta = new PacketPlayOutEntityMetadata(this.armorStand.getId(), this.armorStand.getDataWatcher(), true);
            this.sendPacket((Packet<?>)meta);
        }

        @Override
        public void sendTeleportPacket(Location loc) {
            this.armorStand.setPosition(loc.getX(), loc.getY(), loc.getZ());
            PacketPlayOutEntityTeleport teleport = new PacketPlayOutEntityTeleport((net.minecraft.world.entity.Entity)this.armorStand);
            this.sendPacket((Packet<?>)teleport);
        }

        @Override
        public void sendRemovePacket() {
            PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(this.armorStand.getId());
            this.sendPacket((Packet<?>)remove);
        }

        public void sendPacket(Packet<?> packet) {
            for (Player player : this.players) {
                ((CraftPlayer)player).getHandle().b.sendPacket(packet);
            }
        }
    }
}

