/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.nms.v1_21_0;

import com.zenya.damageindicator.nms.Hologram;
import com.zenya.damageindicator.nms.ProtocolNMS;
import java.util.List;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ProtocolNMSImpl
implements ProtocolNMS {
    @Override
    public Hologram getHologram(LivingEntity ent, Location loc, List<Player> players, String text) {
        return new HologramImpl(ent, loc, players, text);
    }

    public static class HologramImpl
    implements Hologram {
        private final EntityArmorStand armorStand;
        private final LivingEntity entity;
        private final List<Player> players;

        public HologramImpl(LivingEntity entity, Location loc, List<Player> players, String text) {
            this.entity = entity;
            this.players = players;
            WorldServer world = ((CraftWorld)loc.getWorld()).getHandle();
            this.armorStand = new EntityArmorStand((World)world, loc.getX(), loc.getY(), loc.getZ());
            this.armorStand.k(true);
            this.armorStand.v(true);
            this.armorStand.u(true);
            this.armorStand.f(true);
            this.armorStand.b((IChatBaseComponent)IChatMutableComponent.a((ComponentContents)new LiteralContents.a(text)));
            this.armorStand.p(true);
        }

        @Override
        public Hologram spawn(double offsetX, double offsetY, double offsetZ, double speed, long duration) {
            this.sendCreatePacket();
            this.sendMetaPacket();
            new Hologram.HologramRunnable(this, (Entity)this.entity, offsetX, offsetY, offsetZ, speed, duration).start();
            return this;
        }

        @Override
        public void sendCreatePacket() {
            PacketPlayOutSpawnEntity create = new PacketPlayOutSpawnEntity(this.armorStand.an(), this.armorStand.cz(), this.armorStand.dt(), this.armorStand.dv(), this.armorStand.dz(), this.armorStand.dG(), this.armorStand.dE(), this.armorStand.am(), 0, this.armorStand.dr(), (double)this.armorStand.ct());
            this.sendPacket((Packet<?>)create);
        }

        @Override
        public void sendMetaPacket() {
            List dataValues = this.armorStand.ar().b();
            if (dataValues == null) {
                return;
            }
            PacketPlayOutEntityMetadata meta = new PacketPlayOutEntityMetadata(this.armorStand.an(), dataValues);
            this.sendPacket((Packet<?>)meta);
        }

        @Override
        public void sendTeleportPacket(Location loc) {
            this.armorStand.c(loc.getX(), loc.getY(), loc.getZ());
            PacketPlayOutEntityTeleport teleport = new PacketPlayOutEntityTeleport((net.minecraft.world.entity.Entity)this.armorStand);
            this.sendPacket((Packet<?>)teleport);
        }

        @Override
        public void sendRemovePacket() {
            PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.an()});
            this.sendPacket((Packet<?>)remove);
        }

        public void sendPacket(Packet<?> packet) {
            for (Player player : this.players) {
                ((CraftPlayer)player).getHandle().c.b(packet);
            }
        }
    }
}

