/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.nms.v1_21_3;

import com.zenya.damageindicator.nms.Hologram;
import com.zenya.damageindicator.nms.ProtocolNMS;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ProtocolNMSImpl
implements ProtocolNMS {
    @Override
    public Hologram getHologram(LivingEntity ent, Location loc, List<Player> players, String text) {
        return new HologramImpl(ent, loc, players, text);
    }

    public static class HologramImpl
    implements Hologram {
        private final ArmorStand armorStand;
        private final LivingEntity entity;
        private final List<Player> players;

        public HologramImpl(LivingEntity entity, Location loc, List<Player> players, String text) {
            this.entity = entity;
            this.players = players;
            ServerLevel world = ((CraftWorld)loc.getWorld()).getHandle();
            this.armorStand = new ArmorStand((Level)world, loc.getX(), loc.getY(), loc.getZ());
            this.armorStand.setInvisible(true);
            this.armorStand.setMarker(true);
            this.armorStand.setSmall(true);
            this.armorStand.setNoGravity(true);
            this.armorStand.setCustomName((Component)MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(text)));
            this.armorStand.setCustomNameVisible(true);
        }

        @Override
        public Hologram spawn(double offsetX, double offsetY, double offsetZ, double speed, long duration) {
            this.sendCreatePacket();
            this.sendMetaPacket();
            new Hologram.HologramRunnable(this, (Entity)this.entity, offsetX, offsetY, offsetZ, speed, duration).start();
            return this;
        }

        @Override
        public void sendCreatePacket() {
            ClientboundAddEntityPacket create = new ClientboundAddEntityPacket(this.armorStand.getId(), this.armorStand.getUUID(), this.armorStand.getX(), this.armorStand.getY(), this.armorStand.getZ(), this.armorStand.getXRot(), this.armorStand.getYRot(), this.armorStand.getType(), 0, this.armorStand.getDeltaMovement(), (double)this.armorStand.getYHeadRot());
            this.sendPacket((Packet<?>)create);
        }

        @Override
        public void sendMetaPacket() {
            List dataValues = this.armorStand.getEntityData().packDirty();
            if (dataValues == null) {
                return;
            }
            ClientboundSetEntityDataPacket meta = new ClientboundSetEntityDataPacket(this.armorStand.getId(), dataValues);
            this.sendPacket((Packet<?>)meta);
        }

        @Override
        public void sendTeleportPacket(Location loc) {
            this.armorStand.teleportTo(loc.getX(), loc.getY(), loc.getZ());
            ClientboundTeleportEntityPacket teleport = new ClientboundTeleportEntityPacket(this.armorStand.getId(), PositionMoveRotation.of((net.minecraft.world.entity.Entity)this.armorStand), Set.of(), this.armorStand.onGround());
            this.sendPacket((Packet<?>)teleport);
        }

        @Override
        public void sendRemovePacket() {
            ClientboundRemoveEntitiesPacket remove = new ClientboundRemoveEntitiesPacket(new int[]{this.armorStand.getId()});
            this.sendPacket((Packet<?>)remove);
        }

        public void sendPacket(Packet<?> packet) {
            for (Player player : this.players) {
                ((CraftPlayer)player).getHandle().connection.send(packet);
            }
        }
    }
}

