/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.scoreboard;

import com.zenya.damageindicator.DamageIndicator;
import com.zenya.damageindicator.libs.net.insprill.spigotutils.MinecraftVersion;
import com.zenya.damageindicator.libs.net.insprill.spigotutils.ServerEnvironment;
import com.zenya.damageindicator.libs.net.insprill.xenlib.localization.Lang;
import com.zenya.damageindicator.storage.StorageFileManager;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class HealthIndicator {
    private static final String OBJECTIVE_NAME = "di-health";
    private static final String OBJECTIVE_CRITERIA = "health";
    private static final String OBJECTIVE_NAME_KEY = "health";
    public static final HealthIndicator INSTANCE = new HealthIndicator();
    private final Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
    private Objective obj = this.board.getObjective("di-health");

    private HealthIndicator() {
    }

    public void reload() {
        if (ServerEnvironment.isFolia()) {
            DamageIndicator.INSTANCE.getLogger().warning("Folia does not support scoreboards yet. Disabling health indicators!");
            return;
        }
        if (!StorageFileManager.getConfig().getBool("health-indicators")) {
            if (this.obj != null) {
                this.obj.unregister();
                this.obj = null;
            }
            return;
        }
        if (this.obj == null) {
            this.obj = MinecraftVersion.isNew() ? this.board.registerNewObjective(OBJECTIVE_NAME, "health", Lang.get("health", new String[0])) : this.board.registerNewObjective(OBJECTIVE_NAME, "health");
            this.obj.setDisplaySlot(DisplaySlot.BELOW_NAME);
        }
        this.obj.setDisplayName(Lang.get("health", new String[0]));
    }
}

