/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.storage;

import com.zenya.damageindicator.DamageIndicator;
import com.zenya.damageindicator.file.DBFile;
import com.zenya.damageindicator.file.StorageFile;
import com.zenya.damageindicator.file.YAMLFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class StorageFileManager {
    private static final int CONFIG_FILE_VERSION = 4;
    private static final boolean CONFIG_RESET_FILE = false;
    private static final List<String> CONFIG_IGNORED_NODES = new ArrayList<String>(){
        {
            this.add("config-version");
        }
    };
    private static final List<String> CONFIG_REPLACE_NODES = new ArrayList<String>(){
        {
            this.add("disabled-worlds");
        }
    };
    private static final int DATABASE_FILE_VERSION = 0;
    private static final boolean DATABASE_RESET_FILE = false;
    public static final StorageFileManager INSTANCE = new StorageFileManager();
    private final HashMap<String, StorageFile> fileMap = new HashMap();

    public void reloadFiles() {
        StorageFileManager.INSTANCE.fileMap.clear();
        if (StorageFileManager.getDatabase() != null) {
            StorageFileManager.getDatabase().shutdown();
        }
        this.registerFile("config.yml", new YAMLFile(DamageIndicator.INSTANCE.getDataFolder().getPath(), "config.yml", 4, false, CONFIG_IGNORED_NODES, CONFIG_REPLACE_NODES));
        this.registerFile("database.db", new DBFile(DamageIndicator.INSTANCE.getDataFolder().getPath(), "database.db", 0, false));
    }

    public StorageFile getFile(String fileName) {
        return this.fileMap.get(fileName);
    }

    public YAMLFile getYAMLFile(String fileName) {
        return (YAMLFile)this.getFile(fileName);
    }

    public DBFile getDBFile(String fileName) {
        return (DBFile)this.getFile(fileName);
    }

    public Set<String> getFileNames() {
        return this.fileMap.keySet();
    }

    public void registerFile(String fileName, StorageFile file) {
        this.fileMap.put(fileName, file);
    }

    public void unregisterFile(String fileName) {
        this.fileMap.remove(fileName);
    }

    public static YAMLFile getConfig() {
        return (YAMLFile)INSTANCE.getFile("config.yml");
    }

    public static DBFile getDatabase() {
        return (DBFile)INSTANCE.getFile("database.db");
    }
}

