/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.storage;

import com.zenya.damageindicator.storage.StorageFileManager;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ToggleManager {
    public static final ToggleManager INSTANCE = new ToggleManager();
    private final ConcurrentMap<UUID, Boolean> toggleMap = new ConcurrentHashMap<UUID, Boolean>();

    public Boolean isToggled(UUID uuid) {
        if (!this.toggleMap.containsKey(uuid)) {
            StorageFileManager.getDatabase().runOnDbThread(() -> {
                boolean status = StorageFileManager.getDatabase().getToggleStatus(uuid);
                this.cacheToggle(uuid, status);
            });
        }
        return this.toggleMap.getOrDefault(uuid, false);
    }

    public void registerToggle(UUID uuid, boolean status) {
        this.cacheToggle(uuid, status);
        StorageFileManager.getDatabase().runOnDbThread(() -> StorageFileManager.getDatabase().setToggleStatus(uuid, status));
    }

    public void cacheToggle(UUID uuid, boolean enabled) {
        this.toggleMap.put(uuid, enabled);
    }

    public void uncacheToggle(UUID uuid) {
        this.toggleMap.remove(uuid);
    }
}

