/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.util;

import com.zenya.damageindicator.storage.StorageFileManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.ChatColor;

public class DisplayBuilder {
    private String text;
    private Double value;
    private final List<ChatColor> colors = new ArrayList<ChatColor>();

    public DisplayBuilder() {
    }

    public DisplayBuilder(String text) {
        this.text = text;
    }

    public DisplayBuilder(double text) {
        this.text = String.valueOf(text);
    }

    public String getText() {
        return this.text;
    }

    public String getRawText() {
        return ChatColor.stripColor((String)this.text);
    }

    public DisplayBuilder withText(String text) {
        this.text = text;
        return this;
    }

    public DisplayBuilder withText(double text) {
        this.text = String.valueOf(text);
        return this;
    }

    public DisplayBuilder withValue(double value) {
        this.value = value;
        return this;
    }

    public DisplayBuilder withColor(ChatColor ... colors) {
        this.colors.addAll(Arrays.asList(colors));
        return this;
    }

    public DisplayBuilder withColor(char ... codes) {
        for (char code : codes) {
            this.colors.add(ChatColor.getByChar((char)code));
        }
        return this;
    }

    public DisplayBuilder withRainbow() {
        return this.withColor('a', 'b', 'c', 'd', 'e').randomize();
    }

    public DisplayBuilder randomize() {
        ThreadLocalRandom randObj = ThreadLocalRandom.current();
        int n = this.colors.size();
        for (int i = 0; i < n; ++i) {
            int randomValue = i + ((Random)randObj).nextInt(n - i);
            ChatColor randomElement = this.colors.get(randomValue);
            this.colors.set(randomValue, this.colors.get(i));
            this.colors.set(i, randomElement);
        }
        return this;
    }

    public String build() {
        if (this.value != null) {
            String val;
            try {
                val = String.format("%." + StorageFileManager.getConfig().getInt("indicator-decimals") + "f", this.value);
            }
            catch (Exception exc) {
                val = String.format("%.2f", this.value);
            }
            this.text = this.text.replaceAll("%value%", val);
        }
        try {
            String colorModifier = this.text.substring(this.text.indexOf(37), this.text.indexOf(37, this.text.indexOf(37) + 1) + 1);
            this.text = this.text.replaceAll(colorModifier, "");
            if (colorModifier.equalsIgnoreCase("%rainbow%")) {
                this.withRainbow();
            } else {
                char[] colors = new char[colorModifier.length() - 2];
                colorModifier.getChars(1, colorModifier.length() - 1, colors, 0);
                this.withColor(colors);
            }
        }
        catch (StringIndexOutOfBoundsException colors) {
            // empty catch block
        }
        if (this.colors.size() > 0) {
            int colorIndex = this.colors.size() - 1;
            for (int textIndex = this.text.length() - 1; textIndex >= 0; --textIndex) {
                this.setColorAt(textIndex, colorIndex);
                if (--colorIndex >= 0) continue;
                colorIndex = this.colors.size() - 1;
            }
        }
        if (StorageFileManager.getConfig().getBool("bold-indicators")) {
            this.setFormat('l');
        }
        if (StorageFileManager.getConfig().getBool("italic-indicators")) {
            this.setFormat('o');
        }
        if (StorageFileManager.getConfig().getBool("underline-indicators")) {
            this.setFormat('m');
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.text);
    }

    private void setColorAt(int textIndex, int colorIndex) {
        StringBuilder builder = new StringBuilder(this.text);
        builder.insert(textIndex, "&" + this.colors.get(colorIndex).getChar());
        this.text = builder.toString();
    }

    private void setFormat(char format) {
        StringBuilder formatted = new StringBuilder();
        for (int i = 0; i < this.text.length(); ++i) {
            if (this.text.toCharArray()[i] == '&') {
                formatted.append("&").append(this.text.toCharArray()[++i]);
                continue;
            }
            formatted.append("&").append(format).append(this.text.toCharArray()[i]);
        }
        this.text = formatted.toString();
    }
}

