/*
 * Decompiled with CFR 0.152.
 */
package cc.sophiethefox.minecraftheadsbrowser.gui;

import cc.sophiethefox.minecraftheadsbrowser.HeadData;
import cc.sophiethefox.minecraftheadsbrowser.HeadManager;
import cc.sophiethefox.minecraftheadsbrowser.MinecraftHeadsBrowser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.SmallCheckboxComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.CollapsibleContainer;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.CommandOpenedScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class MCHeadsScreen
extends BaseOwoScreen<FlowLayout>
implements CommandOpenedScreen {
    private final List<HeadData> headDataList = new ArrayList<HeadData>();
    private final int skullsPerPage = 1000;
    private List<String> activeCategories = new ArrayList<String>();
    private int page = 0;
    private FlowLayout skullContainer;
    private TextBoxComponent searchComponent;
    private TextBoxComponent setPageComponent;
    private String lastSearch = "";
    private boolean useNbt = false;

    public static String uuidToNBTIntArray(String uuidString) {
        UUID uuid = UUID.fromString(uuidString);
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        int i1 = (int)(msb >> 32);
        int i2 = (int)msb;
        int i3 = (int)(lsb >> 32);
        int i4 = (int)lsb;
        return String.format("[I;%d,%d,%d,%d]", i1, i2, i3, i4);
    }

    public void method_25426() {
        HeadManager manager = MinecraftHeadsBrowser.headManager;
        if (manager.activeCategories == null || !MinecraftHeadsBrowser.CONFIG.saveCategories()) {
            this.activeCategories.addAll(List.of("alphabet", "animals", "blocks", "decoration", "food-drinks", "humans", "humanoid", "miscellaneous", "monsters", "plants"));
        } else {
            this.activeCategories = manager.activeCategories;
        }
        this.page = manager.page == null || !MinecraftHeadsBrowser.CONFIG.savePage() ? 0 : manager.page;
        if (manager.searchTerm != null && MinecraftHeadsBrowser.CONFIG.saveSearch()) {
            this.lastSearch = manager.searchTerm;
        }
        if (manager.nbtEdit != null && MinecraftHeadsBrowser.CONFIG.saveNBTEdit()) {
            this.useNbt = manager.nbtEdit;
        }
        super.method_25426();
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        if (this.headDataList.isEmpty()) {
            this.headDataList.addAll(MinecraftHeadsBrowser.headManager.categorizedHeads.values().stream().flatMap(Collection::stream).toList());
        }
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.CENTER).padding(Insets.left((int)(this.field_22789 / 10)).withRight(this.field_22789 / 10));
        CollapsibleContainer filtersCollapsible = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (class_2561)class_2561.method_43470((String)"Categories"), (boolean)false);
        filtersCollapsible.horizontalAlignment(HorizontalAlignment.LEFT);
        FlowLayout filtersLayout = Containers.ltrTextFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
        filtersLayout.horizontalAlignment(HorizontalAlignment.LEFT);
        HashMap<String, String> categories = new HashMap<String, String>();
        categories.put("Alphabet", "alphabet");
        categories.put("Animals", "animals");
        categories.put("Blocks", "blocks");
        categories.put("Decoration", "decoration");
        categories.put("Food & Drinks", "food-drinks");
        categories.put("Humans", "humans");
        categories.put("Humanoid", "humanoid");
        categories.put("Misc", "miscellaneous");
        categories.put("Monsters", "monsters");
        categories.put("Plants", "plants");
        for (Map.Entry category : categories.entrySet()) {
            SmallCheckboxComponent checkboxComponent = Components.smallCheckbox((class_2561)class_2561.method_30163((String)((String)category.getKey()))).checked(this.activeCategories.contains(category.getValue()));
            checkboxComponent.onChanged().subscribe(checked -> {
                if (checked) {
                    this.activeCategories.add((String)category.getValue());
                } else {
                    this.activeCategories.remove(category.getValue());
                }
                this.updatePage("1");
                MinecraftHeadsBrowser.headManager.saveState(this.activeCategories, this.searchComponent.method_1882(), this.page, this.useNbt);
                this.updateSkulls(this.activeCategories, this.searchComponent.method_1882());
            });
            filtersLayout.child((Component)checkboxComponent);
        }
        filtersCollapsible.child((Component)filtersLayout);
        this.skullContainer = Containers.ltrTextFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
        this.skullContainer.padding(Insets.of((int)5)).allowOverflow(false).surface(Surface.PANEL);
        this.updateSkullsContainer();
        ScrollContainer skullScrollContainer = Containers.verticalScroll((Sizing)Sizing.content(), (Sizing)Sizing.fill((int)70), (Component)this.skullContainer);
        skullScrollContainer.scrollbarThiccness(4).scrollbar(ScrollContainer.Scrollbar.vanillaFlat()).surface(Surface.PANEL);
        ButtonComponent prevPageButton = Components.button((class_2561)class_2561.method_30163((String)"Prev"), buttonComponent -> this.prevPage());
        ButtonComponent nextPageButton = Components.button((class_2561)class_2561.method_30163((String)"Next"), buttonComponent -> this.nextPage());
        this.setPageComponent = Components.textBox((Sizing)Sizing.expand((int)10), (String)String.valueOf(this.page + 1));
        FlowLayout searchComponents = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        searchComponents.verticalAlignment(VerticalAlignment.CENTER);
        LabelComponent searchComponentLabel = Components.label((class_2561)class_2561.method_30163((String)"Search:"));
        this.searchComponent = Components.textBox((Sizing)Sizing.expand((int)10), (String)this.lastSearch);
        this.searchComponent.onChanged().subscribe(s -> {
            this.setPageComponent.method_1852("1");
            this.page = 0;
            MinecraftHeadsBrowser.headManager.saveState(this.activeCategories, this.searchComponent.method_1882().toLowerCase(), this.page, this.useNbt);
            this.updateSkulls(this.activeCategories, s.toLowerCase());
        });
        searchComponents.child((Component)searchComponentLabel);
        searchComponents.child((Component)this.searchComponent);
        SmallCheckboxComponent useNbtCheckbox = Components.smallCheckbox((class_2561)class_2561.method_30163((String)"Modify NBT")).checked(this.useNbt);
        useNbtCheckbox.tooltip(class_2561.method_30163((String)"Hold a player head in hand. \nThis feature will overwrite the NBT to set the skin. \nCreative mode required. \nMay not be allowed on all servers."));
        useNbtCheckbox.onChanged().subscribe(b -> {
            this.useNbt = b;
            MinecraftHeadsBrowser.headManager.saveState(this.activeCategories, this.searchComponent.method_1882().toLowerCase(), this.page, this.useNbt);
        });
        FlowLayout pageNavContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        pageNavContainer.child((Component)prevPageButton);
        pageNavContainer.child((Component)this.setPageComponent);
        pageNavContainer.child((Component)nextPageButton);
        pageNavContainer.child((Component)useNbtCheckbox);
        rootComponent.child((Component)searchComponents);
        rootComponent.child((Component)filtersCollapsible);
        rootComponent.child((Component)skullScrollContainer);
        rootComponent.child((Component)pageNavContainer);
        this.updateSkulls(this.activeCategories, this.searchComponent.method_1882());
    }

    private void updateSkulls(List<String> categories, String search) {
        this.headDataList.clear();
        for (String category : MinecraftHeadsBrowser.headManager.categorizedHeads.keySet()) {
            if (!categories.contains(category)) continue;
            this.headDataList.addAll(MinecraftHeadsBrowser.headManager.categorizedHeads.get(category).stream().filter(headData -> headData.name.toLowerCase().contains(search)).toList());
        }
        this.updateSkullsContainer();
    }

    private void updateSkullsContainer() {
        int startIndex = this.page * 1000;
        int endIndex = startIndex + 1000;
        this.skullContainer.clearChildren();
        for (int i = startIndex; i < this.headDataList.size() && i < endIndex; ++i) {
            HeadData skullData = this.headDataList.get(i);
            class_1799 itemStack = MinecraftHeadsBrowser.headManager.createSkullFromHeadData(skullData);
            ItemComponent skull = Components.item((class_1799)itemStack).setTooltipFromStack(true);
            this.skullContainer.child((Component)skull);
            skull.mouseDown().subscribe((v, v1, i1) -> {
                if (this.useNbt) {
                    class_746 player = class_310.method_1551().field_1724;
                    class_1799 heldItem = player.method_5998(class_1268.field_5808);
                    if (player.method_56992()) {
                        if (heldItem.method_31574(class_1802.field_8575)) {
                            class_1799 newStack = heldItem.method_7972();
                            GameProfile profile = new GameProfile(skullData.uuid != null ? UUID.fromString(skullData.uuid) : UUID.randomUUID(), "Head");
                            profile.getProperties().put((Object)"textures", (Object)new Property("textures", skullData.value));
                            class_9296 profileComponent = new class_9296(profile);
                            newStack.method_57379(class_9334.field_49617, (Object)profileComponent);
                            if (skullData.name != null) {
                                newStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)skullData.name));
                            }
                            int selectedSlot = player.method_31548().field_7545;
                            player.method_31548().method_5447(selectedSlot, newStack);
                            int creativeSlotIndex = selectedSlot + 36;
                            class_2873 packet = new class_2873(creativeSlotIndex, newStack);
                            class_310.method_1551().method_1562().method_52787((class_2596)packet);
                        } else {
                            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"\u00a74Please ensure you are holding a player head!"), false);
                            player.method_17356((class_3414)class_3417.field_18311.comp_349(), class_3419.field_15245, 10.0f, 0.3f);
                            this.method_25419();
                        }
                    } else {
                        class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"\u00a74Please ensure you are in creative mode!"), false);
                        player.method_17356((class_3414)class_3417.field_18311.comp_349(), class_3419.field_15245, 10.0f, 0.3f);
                        this.method_25419();
                    }
                } else {
                    String id = MCHeadsScreen.uuidToNBTIntArray(skullData.uuid);
                    String texture = skullData.value;
                    String headName = skullData.name;
                    String giveCommand = "/give @s minecraft:player_head[minecraft:custom_name='{\"text\":\"%s\",\"color\":\"gold\",\"underlined\":true,\"bold\":true,\"italic\":false}',minecraft:lore=['{\"text\":\"www.minecraft-heads.com\",\"color\":\"blue\",\"italic\":false}'],profile={id:%s,properties:[{name:\"textures\",value:\"%s\"}]}] 1".formatted(headName, id, texture);
                    class_310.method_1551().field_1724.field_3944.method_45730(giveCommand.substring(1));
                }
                return true;
            });
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 257 || keyCode == 256) && this.setPageComponent.method_25370()) {
            this.updatePage(this.setPageComponent.method_1882());
            this.method_25402(((Positioning)this.searchComponent.positioning().get()).x, ((Positioning)this.searchComponent.positioning().get()).y, 0);
            return true;
        }
        if ((keyCode == 257 || keyCode == 256) && this.searchComponent.method_25370()) {
            this.method_25402(((Positioning)this.searchComponent.positioning().get()).x, ((Positioning)this.searchComponent.positioning().get()).y, 0);
            return true;
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 262) {
            this.nextPage();
            return true;
        }
        if (keyCode == 263) {
            this.prevPage();
            return true;
        }
        return false;
    }

    private void nextPage() {
        int totalPages = (int)Math.ceil((double)this.headDataList.size() / 1000.0);
        if (this.page + 1 == totalPages) {
            return;
        }
        ++this.page;
        this.setPageComponent.method_1852(String.valueOf(this.page + 1));
        MinecraftHeadsBrowser.headManager.saveState(this.activeCategories, this.searchComponent.method_1882(), this.page, this.useNbt);
        this.updateSkullsContainer();
    }

    private void prevPage() {
        if (this.page == 0) {
            return;
        }
        --this.page;
        this.setPageComponent.method_1852(String.valueOf(this.page + 1));
        MinecraftHeadsBrowser.headManager.saveState(this.activeCategories, this.searchComponent.method_1882(), this.page, this.useNbt);
        this.updateSkullsContainer();
    }

    private void updatePage(String page) {
        try {
            int p = Integer.parseInt(page) - 1;
            int totalPages = (int)Math.ceil((double)this.headDataList.size() / 1000.0);
            if (p < 0) {
                this.setPageComponent.method_1852("1");
                p = 0;
            }
            if (p > totalPages) {
                this.setPageComponent.method_1852(String.valueOf(totalPages));
                p = totalPages - 1;
            }
            this.page = p;
            MinecraftHeadsBrowser.headManager.saveState(this.activeCategories, this.searchComponent.method_1882(), this.page, this.useNbt);
            this.updateSkullsContainer();
        }
        catch (Exception e) {
            this.setPageComponent.method_1852("1");
        }
    }
}

