/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.ironbookshelves.init;

import com.jahirtrap.ironbookshelves.block.AmethystBookshelfBlock;
import com.jahirtrap.ironbookshelves.block.BaseBookshelfBlock;
import com.jahirtrap.ironbookshelves.block.CryingObsidianBookshelfBlock;
import com.jahirtrap.ironbookshelves.init.ModConfig;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModContent {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ironbookshelves");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ironbookshelves");
    public static final DeferredBlock<Block> IRON_BOOKSHELF = ModContent.registerBlock("iron_bookshelf", p -> new BaseBookshelfBlock(ModConfig.ironEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.IRON_BLOCK), new Item.Properties());
    public static final DeferredBlock<Block> GOLDEN_BOOKSHELF = ModContent.registerBlock("golden_bookshelf", p -> new BaseBookshelfBlock(ModConfig.goldenEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.GOLD_BLOCK), new Item.Properties());
    public static final DeferredBlock<Block> DIAMOND_BOOKSHELF = ModContent.registerBlock("diamond_bookshelf", p -> new BaseBookshelfBlock(ModConfig.diamondEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK), new Item.Properties());
    public static final DeferredBlock<Block> EMERALD_BOOKSHELF = ModContent.registerBlock("emerald_bookshelf", p -> new BaseBookshelfBlock(ModConfig.emeraldEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.EMERALD_BLOCK), new Item.Properties());
    public static final DeferredBlock<Block> OBSIDIAN_BOOKSHELF = ModContent.registerBlock("obsidian_bookshelf", p -> new BaseBookshelfBlock(ModConfig.obsidianEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OBSIDIAN), new Item.Properties());
    public static final DeferredBlock<Block> NETHERITE_BOOKSHELF = ModContent.registerBlock("netherite_bookshelf", p -> new BaseBookshelfBlock(ModConfig.netheriteEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK), new Item.Properties().fireResistant());
    public static final DeferredBlock<Block> COPPER_BOOKSHELF = ModContent.registerBlock("copper_bookshelf", p -> new BaseBookshelfBlock(ModConfig.copperEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.COPPER_BLOCK), new Item.Properties());
    public static final DeferredBlock<Block> AMETHYST_BOOKSHELF = ModContent.registerBlock("amethyst_bookshelf", p -> new AmethystBookshelfBlock(ModConfig.amethystEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK), new Item.Properties());
    public static final DeferredBlock<Block> CRYING_OBSIDIAN_BOOKSHELF = ModContent.registerBlock("crying_obsidian_bookshelf", p -> new CryingObsidianBookshelfBlock(ModConfig.cryingObsidianEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.CRYING_OBSIDIAN), new Item.Properties());
    public static final DeferredBlock<Block> ENDERITE_BOOKSHELF = ModContent.registerBlock("enderite_bookshelf", p -> new BaseBookshelfBlock(ModConfig.enderiteEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).sound(SoundType.NETHERITE_BLOCK).strength(66.0f, 1200.0f).requiresCorrectToolForDrops(), new Item.Properties().fireResistant());
    public static final DeferredBlock<Block> STEEL_BOOKSHELF = ModContent.registerBlock("steel_bookshelf", p -> new BaseBookshelfBlock(ModConfig.steelEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static final DeferredBlock<Block> BRONZE_BOOKSHELF = ModContent.registerBlock("bronze_bookshelf", p -> new BaseBookshelfBlock(ModConfig.bronzeEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static final DeferredBlock<Block> ZURITE_BOOKSHELF = ModContent.registerBlock("zurite_bookshelf", p -> new BaseBookshelfBlock(ModConfig.zuriteEnchantPower, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK).mapColor(MapColor.COLOR_GRAY), new Item.Properties().fireResistant());

    private static DeferredBlock<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp, Item.Properties itemProp) {
        DeferredBlock<Block> blockReg = ModContent.registerBlock(name, function, blockProp);
        ModContent.registerItem(name, p -> new BlockItem((Block)blockReg.get(), p), itemProp.useBlockDescriptionPrefix());
        return blockReg;
    }

    private static DeferredBlock<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp) {
        return BLOCKS.register(name, () -> (Block)function.apply(blockProp.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ironbookshelves", (String)name)))));
    }

    private static DeferredItem<Item> registerItem(String name, Function<Item.Properties, Item> function, Item.Properties itemProp) {
        return ITEMS.register(name, () -> (Item)function.apply(itemProp.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ironbookshelves", (String)name)))));
    }

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
    }
}

