/*
 * Decompiled with CFR 0.152.
 */
package com.apegale.catstayhome;

import com.apegale.catstayhome.WrappedTeleportGoal;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="catstayhome")
public final class CatTeleportControl {
    public static final String TELEPORT_KEY = "CatControlAllowTeleport";

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Cat)) {
            return;
        }
        Cat cat = (Cat)entity;
        CompoundTag data = cat.getPersistentData();
        if (!data.contains(TELEPORT_KEY)) {
            data.putBoolean(TELEPORT_KEY, true);
        }
        CatTeleportControl.injectTeleportWrapper(cat);
    }

    @SubscribeEvent
    public static void onCatRightClick(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Cat)) {
            return;
        }
        Cat cat = (Cat)entity;
        Player player = event.getEntity();
        if (!player.isCrouching()) {
            return;
        }
        if (!cat.isTame() || !cat.isOwnedBy((LivingEntity)player)) {
            return;
        }
        if (player.level().isClientSide()) {
            return;
        }
        CompoundTag data = cat.getPersistentData();
        boolean current = data.getBoolean(TELEPORT_KEY).orElse(true);
        boolean newValue = !current;
        data.putBoolean(TELEPORT_KEY, newValue);
        player.displayClientMessage((Component)Component.translatable((String)(!newValue ? "message.catstayhome.teleport_disabled" : "message.catstayhome.teleport_enabled")), true);
        event.setCanceled(true);
    }

    private static void injectTeleportWrapper(Cat cat) {
        Object[] available;
        for (Object o : available = cat.goalSelector.getAvailableGoals().toArray(new Object[0])) {
            WrappedGoal wg;
            Goal goal;
            String simpleName;
            String lower;
            if (!(o instanceof WrappedGoal) || !(lower = (simpleName = (goal = (wg = (WrappedGoal)o).getGoal()).getClass().getSimpleName()).toLowerCase(Locale.ROOT)).contains("teleport") && !lower.contains("followowner") && (!lower.contains("follow") || lower.contains("leash"))) continue;
            int priority = wg.getPriority();
            cat.goalSelector.removeGoal(goal);
            cat.goalSelector.addGoal(priority, (Goal)new WrappedTeleportGoal(cat, goal));
            return;
        }
    }
}

