/*
 * Decompiled with CFR 0.152.
 */
package com.mx.hzuc.screen;

import com.mx.hzuc.block.ModBlocks;
import com.mx.hzuc.screen.LineReplacementHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class LineStyleSelectionScreen
extends class_437 {
    private static final List<class_2248> ALL_BLOCKS = new ArrayList<class_2248>();
    private int selectedIndex = -1;
    private class_2248 selectedBlock = null;
    private int currentPage = 0;
    private static final int ITEMS_PER_PAGE = 28;
    private int totalPages = (int)Math.ceil((double)ALL_BLOCKS.size() / 28.0);
    private static final int COLUMNS = 7;
    private static final int ROWS = 4;
    private static final int ITEM_SIZE = 20;
    private static final int ITEM_SPACING = 25;
    private static final int PREVIEW_SIZE = 48;
    private int gridStartX;
    private int gridStartY;
    private int previewX;
    private int previewY;
    private int buttonsStartX;
    private int buttonsStartY;

    public LineStyleSelectionScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.hzucmod.line_selection.title"));
    }

    protected void method_25426() {
        super.method_25426();
        int windowWidth = 450;
        int windowHeight = 280;
        int x = (this.field_22789 - windowWidth) / 2;
        int y = (this.field_22790 - windowHeight) / 2;
        this.gridStartX = x + 20;
        this.gridStartY = y + 50;
        this.buttonsStartX = x + windowWidth - 110;
        this.buttonsStartY = y + 170;
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonSpacing = 25;
        class_4185 prevButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190 \u4e0a\u4e00\u9875"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.selectedIndex = -1;
                this.selectedBlock = null;
            }
        }).method_46434(this.gridStartX, y + windowHeight - 35, 60, buttonHeight).method_46431();
        this.method_37063((class_364)prevButton);
        class_4185 nextButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u4e0b\u4e00\u9875 \u2192"), button -> {
            if (this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
                this.selectedIndex = -1;
                this.selectedBlock = null;
            }
        }).method_46434(this.gridStartX + 70, y + windowHeight - 35, 60, buttonHeight).method_46431();
        this.method_37063((class_364)nextButton);
        class_4185 clearButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hzucmod.line_selection.clear"), button -> {
            this.selectedIndex = -1;
            this.selectedBlock = null;
            LineReplacementHandler.setSelectedBlock(null);
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.hzucmod.selection_cleared"), false);
            }
        }).method_46434(this.buttonsStartX, this.buttonsStartY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)clearButton);
        class_4185 confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hzucmod.line_selection.confirm"), button -> this.confirmSelection()).method_46434(this.buttonsStartX, this.buttonsStartY + buttonSpacing, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)confirmButton);
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hzucmod.line_selection.cancel"), button -> this.method_25419()).method_46434(this.buttonsStartX, this.buttonsStartY + buttonSpacing * 2, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)cancelButton);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!ALL_BLOCKS.isEmpty()) {
            if (amount > 0.0 && this.currentPage > 0) {
                --this.currentPage;
                this.selectedIndex = -1;
                this.selectedBlock = null;
            } else if (amount < 0.0 && this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
                this.selectedIndex = -1;
                this.selectedBlock = null;
            }
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, ALL_BLOCKS.size());
        for (int i = startIndex; i < endIndex; ++i) {
            int pageIndex = i - startIndex;
            int row = pageIndex / 7;
            int col = pageIndex % 7;
            int itemX = this.gridStartX + col * 25;
            int itemY = this.gridStartY + row * 25;
            if (!(mouseX >= (double)itemX) || !(mouseX <= (double)(itemX + 20)) || !(mouseY >= (double)itemY) || !(mouseY <= (double)(itemY + 20))) continue;
            this.selectedIndex = i;
            this.selectedBlock = ALL_BLOCKS.get(i);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int windowWidth = 450;
        int windowHeight = 280;
        int x = (this.field_22789 - windowWidth) / 2;
        int y = (this.field_22790 - windowHeight) / 2;
        context.method_25294(x, y, x + windowWidth, y + windowHeight, -872415232);
        context.method_49601(x, y, windowWidth, windowHeight, -1);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, y + 15, 0xFFFFFF);
        String pageInfo = "\u7b2c " + (this.currentPage + 1) + " \u9875 / \u5171 " + this.totalPages + " \u9875";
        context.method_25300(this.field_22793, pageInfo, this.field_22789 / 2, y + 30, 0xFFFF00);
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, ALL_BLOCKS.size());
        for (int i = startIndex; i < endIndex; ++i) {
            int pageIndex = i - startIndex;
            int row = pageIndex / 7;
            int col = pageIndex % 7;
            int itemX = this.gridStartX + col * 25;
            int itemY = this.gridStartY + row * 25;
            class_2248 block = ALL_BLOCKS.get(i);
            context.method_51427(new class_1799((class_1935)block), itemX, itemY);
            if (i == this.selectedIndex) {
                context.method_49601(itemX - 2, itemY - 2, 24, 24, -256);
            }
            if (mouseX < itemX || mouseX > itemX + 20 || mouseY < itemY || mouseY > itemY + 20) continue;
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)block.method_9518().getString()), mouseX, mouseY);
        }
        int previewBoxWidth = 120;
        int previewBoxHeight = 120;
        int previewBoxX = x + windowWidth - previewBoxWidth - 15;
        int previewBoxY = y + 40;
        context.method_25294(previewBoxX, previewBoxY, previewBoxX + previewBoxWidth, previewBoxY + previewBoxHeight, -1440603614);
        context.method_49601(previewBoxX, previewBoxY, previewBoxWidth, previewBoxHeight, -1);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hzucmod.line_selection.preview"), previewBoxX + previewBoxWidth / 2, previewBoxY - 15, 0xFFFFFF);
        if (this.selectedBlock != null) {
            class_1799 enlargedStack = new class_1799((class_1935)this.selectedBlock);
            int enlargedSize = 64;
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)(previewBoxX + previewBoxWidth / 2), (float)(previewBoxY + previewBoxHeight / 2 - 10), 0.0f);
            context.method_51448().method_22905(3.0f, 3.0f, 1.0f);
            context.method_51427(enlargedStack, -8, -8);
            context.method_51448().method_22909();
            String blockName = this.selectedBlock.method_9518().getString();
            int textY = previewBoxY + previewBoxHeight - 20;
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)blockName), previewBoxX + previewBoxWidth / 2, textY, 0xFFFFFF);
            int maxTextWidth = previewBoxWidth - 10;
            if (this.field_22793.method_1727(blockName) > maxTextWidth) {
                String shortenedName = this.field_22793.method_27523(blockName, maxTextWidth - 10) + "...";
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)shortenedName), previewBoxX + previewBoxWidth / 2, textY, 0xFFFFFF);
            }
        } else {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hzucmod.line_selection.no_preview"), previewBoxX + previewBoxWidth / 2, previewBoxY + previewBoxHeight / 2 - 5, 0xAAAAAA);
        }
        if (this.selectedBlock != null) {
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hzucmod.line_selection.selected"), this.gridStartX, y + windowHeight - 55, 65280);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)("\u7f16\u53f7: " + (this.selectedIndex + 1) + " / " + ALL_BLOCKS.size())), this.gridStartX, y + windowHeight - 45, 0xFFFF00);
        } else {
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hzucmod.line_selection.no_selection"), this.gridStartX, y + windowHeight - 55, 0xFF5555);
        }
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hzucmod.line_selection.scroll_hint"), this.gridStartX, y + windowHeight - 25, 0xAAAAAA);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void confirmSelection() {
        if (this.selectedBlock != null) {
            LineReplacementHandler.setSelectedBlock(this.selectedBlock);
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43469((String)"message.hzucmod.block_selected", (Object[])new Object[]{this.selectedBlock.method_9518()}), false);
            }
        } else {
            LineReplacementHandler.setSelectedBlock(null);
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.hzucmod.selection_cancelled"), false);
            }
        }
        this.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    static {
        ALL_BLOCKS.add(ModBlocks.ROAD_BLOCK1);
        ALL_BLOCKS.add(ModBlocks.ROAD_BLOCK2);
        ALL_BLOCKS.add(ModBlocks.TE_STOP_BLOCK);
        ALL_BLOCKS.add(ModBlocks.CYAN_TERRACOTTA_SLAB);
        ALL_BLOCKS.add(ModBlocks.RB2_WHITE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_X_WHITE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_WHITE_RIGHT_ANGLE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_WHITE_SINGLE_CELL_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_X_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_YELLOW_RIGHT_ANGLE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_YELLOW_SINGLE_CELL_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_DOUBLE_WITH_WHITE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_DOUBLE_WITH_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_DOUBLE_ONE_WITH_WHITE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_DOUBLE_ONE_WITH_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_WHITE_MIDDLE_THINK_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.RB2_YELLOW_MIDDLE_THINK_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_X_WHITE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_X_WHITE_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_RIGHT_ANGLE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_RIGHT_ANGLE_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_SINGLE_CELL_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_SINGLE_CELL_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_DOUBLE_WITH_WHITE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_DOUBLE_WITH_WHITE_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_DOUBLE_ONE_WITH_WHITE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_DOUBLE_ONE_WITH_WHITE_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_MIDDLE_THINK_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_MIDDLE_THINK_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_X_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_YELLOW_RIGHT_ANGLE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_YELLOW_SINGLE_CELL_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_DOUBLE_WITH_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_DOUBLE_WITH_YELLOW_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_DOUBLE_ONE_WITH_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_DOUBLE_ONE_WITH_YELLOW_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_YELLOW_MIDDLE_THINK_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_YELLOW_MIDDLE_THINK_LINE_OLD1_SLAB);
        ALL_BLOCKS.add(ModBlocks.TE_DOUBLE_WITH_WHITE_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_YELLOW_RIGHT_ANGLE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_YELLOW_WHITE_RIGHT_ANGLE_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_WHITE_YELLOW_LINE_OLD1_BLOCK);
        ALL_BLOCKS.add(ModBlocks.TE_X_WHITE_YELLOW_LINE_OLD1_BLOCK);
    }
}

