/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPostEvent;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.particles.AlphaParticleEffect;
import kotlin.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class ModEvents {
    public static void registerEvents() {
        CobblemonEvents.BATTLE_STARTED_POST.subscribe(Priority.HIGH, ModEvents::onBattleStarted);
    }

    private static Unit onBattleStarted(BattleStartedPostEvent event) {
        PokemonBattle battle = event.getBattle();
        boolean wildIsAlpha = false;
        BattlePokemon alphaWild = null;
        for (BattleActor actor : battle.getActors()) {
            BattlePokemon wild;
            Pokemon original;
            if (actor.getType() != ActorType.WILD || actor.getPokemonList().isEmpty() || (original = (wild = (BattlePokemon)actor.getPokemonList().getFirst()).getOriginalPokemon()) == null || !original.getPersistentData().getBoolean("IS_ALPHA")) continue;
            wildIsAlpha = true;
            alphaWild = wild;
            break;
        }
        if (!wildIsAlpha || alphaWild == null) {
            return Unit.INSTANCE;
        }
        Pokemon alphaMon = alphaWild.getOriginalPokemon();
        alphaWild.getStatChanges().put(Stats.ATTACK, 2);
        alphaWild.getStatChanges().put(Stats.DEFENCE, 2);
        alphaWild.getStatChanges().put(Stats.HP, 2);
        alphaWild.getStatChanges().put(Stats.SPECIAL_ATTACK, 2);
        alphaWild.getStatChanges().put(Stats.SPECIAL_DEFENCE, 2);
        alphaWild.getStatChanges().put(Stats.SPEED, 2);
        CobblemonAlphasMod.LOGGER.info("Alpha {} detected \u2014 applying Wild Might boosts.", (Object)alphaMon.getSpecies().getName());
        PokemonEntity entity = alphaMon.getEntity();
        if (entity != null) {
            AlphaParticleEffect.wildMight(entity);
        }
        MutableComponent msg = Component.literal((String)"The Alpha is filled with Wild Might!").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
        for (ServerPlayer player : battle.getPlayers()) {
            player.displayClientMessage((Component)msg, true);
        }
        return Unit.INSTANCE;
    }
}

