/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.cudzer.cobblemonalphas.data.AlphaJsonDataManager;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaSpawner;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class SpawnAlphaCommand {
    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"alphaspawn").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"pokemon", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(SpawnAlphaCommand.getAlphaNames(), (SuggestionsBuilder)sb)).then(Commands.argument((String)"spawnHerd", (ArgumentType)BoolArgumentType.bool()).executes(SpawnAlphaCommand::spawnAlpha))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"alphaspawn").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"random").then(Commands.argument((String)"spawnHerd", (ArgumentType)BoolArgumentType.bool()).executes(SpawnAlphaCommand::spawnAlphaRandom))));
    }

    private static int spawnAlpha(CommandContext<CommandSourceStack> context) {
        return SpawnAlphaCommand.spawn(context, false);
    }

    private static int spawnAlphaRandom(CommandContext<CommandSourceStack> context) {
        return SpawnAlphaCommand.spawn(context, true);
    }

    private static int spawn(CommandContext<CommandSourceStack> context, boolean isRandom) {
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            Alpha alpha = isRandom ? AlphaJsonDataManager.getRandomAlphaObj((Level)((CommandSourceStack)context.getSource()).getLevel()) : AlphaJsonDataManager.getAlphaObj((Level)((CommandSourceStack)context.getSource()).getLevel(), StringArgumentType.getString(context, (String)"pokemon"));
            boolean spawnHerd = BoolArgumentType.getBool(context, (String)"spawnHerd");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Source player not found!"));
                return -1;
            }
            Vec3i spawnPos = new Vec3i((int)player.getX(), (int)player.getY(), (int)player.getZ());
            if (alpha == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Alpha not found!"));
                return -1;
            }
            AlphaSpawner.getInstance().spawnAlphaEntity(alpha, player.level(), spawnPos, spawnHerd);
        }
        return 1;
    }

    private static Set<String> getAlphaNames() {
        Map<ResourceLocation, Alpha> alphaData = AlphaJsonDataManager.getAlphaData();
        HashSet<String> names = new HashSet<String>();
        for (Alpha alpha : alphaData.values()) {
            names.add(alpha.getSpecies());
        }
        return names;
    }
}

