/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.entity.HerdMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public class Alpha {
    public static Codec<Alpha> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("species").forGetter(t -> t.species), (App)Codec.STRING.fieldOf("level").forGetter(w -> w.levelRange), (App)Codec.BOOL.fieldOf("spawnUnderground").forGetter(s -> s.spawnUnderground), (App)HerdMember.CODEC.listOf().fieldOf("herdMembers").forGetter(h -> h.herdMembers), (App)ExtraCodecs.TAG_OR_ELEMENT_ID.listOf().optionalFieldOf("biome", Collections.emptyList()).forGetter(t -> t.biomeTags)).apply((Applicative)inst, Alpha::new));
    protected final String species;
    protected int level = 1;
    protected final String levelRange;
    protected final boolean spawnUnderground;
    protected final List<HerdMember> herdMembers;
    protected final List<ResourceLocation> spawnBiome;
    protected final List<ResourceLocation> spawnBiomeTags;
    protected final List<ExtraCodecs.TagOrElementLocation> biomeTags;
    private ResourceLocation jsonLocation;
    private int minLevel = 1;
    private int maxLevel = 1;

    public Alpha(String species, String levelRange, boolean spawnUnderground, List<HerdMember> herdMembers, List<ExtraCodecs.TagOrElementLocation> spawnBiome) {
        this.species = species;
        this.levelRange = levelRange;
        this.spawnUnderground = spawnUnderground;
        String[] levels = levelRange.split("-");
        if (levels.length == 1) {
            this.level = Integer.parseInt(levels[0]);
        } else if (levels.length == 2) {
            this.minLevel = Integer.parseInt(levels[0]);
            this.maxLevel = Integer.parseInt(levels[1]);
        } else {
            CobblemonAlphasMod.LOGGER.warn(String.format("Incorrect values defined for levels in alpha %s file. Assigning default values", species));
            this.minLevel = 40;
            this.maxLevel = 50;
        }
        this.herdMembers = herdMembers;
        ArrayList<ResourceLocation> spawnBiomeTags = new ArrayList<ResourceLocation>();
        ArrayList<ResourceLocation> spawnBiomes = new ArrayList<ResourceLocation>();
        for (ExtraCodecs.TagOrElementLocation tagOrElementLocation : spawnBiome) {
            if (tagOrElementLocation.tag()) {
                spawnBiomeTags.add(tagOrElementLocation.id());
                continue;
            }
            spawnBiomes.add(tagOrElementLocation.id());
        }
        this.spawnBiome = spawnBiomes;
        this.spawnBiomeTags = spawnBiomeTags;
        this.biomeTags = spawnBiome;
    }

    public void setJsonLocation(ResourceLocation jsonLocation) {
        this.jsonLocation = jsonLocation;
    }

    public ResourceLocation getJsonLocation() {
        try {
            return this.jsonLocation;
        }
        catch (Exception e) {
            CobblemonAlphasMod.LOGGER.error(String.format("Could not find json location due to %s", e));
            return ResourceLocation.parse((String)"");
        }
    }

    public String getSpecies() {
        return this.species;
    }

    public boolean canSpawnUnderground() {
        return this.spawnUnderground;
    }

    public List<HerdMember> getHerdMembers() {
        return this.herdMembers;
    }

    public List<ResourceLocation> getSpawnBiome() {
        return this.spawnBiome;
    }

    public List<ResourceLocation> getSpawnBiomeTags() {
        return this.spawnBiomeTags;
    }

    public int getLevelFromRange() {
        if (this.level != 1) {
            return this.level;
        }
        return new Random().nextInt(this.minLevel, this.maxLevel);
    }
}

