/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.abilities.AbilityPool;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.entity.Despawner;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.cudzer.cobblemonalphas.config.ModConfig;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaDespawner;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;

public class AlphaGenerator {
    private static final Random RNG = new Random();
    private static final String[] statNames = new String[]{"HP", "ATTACK", "DEFENCE", "SPECIAL_ATTACK", "SPECIAL_DEFENCE", "SPEED"};

    public static PokemonEntity generate(Alpha chosenAlpha, Level spawnLevel, Vec3i spawnPos) {
        PokemonEntity alphaEntity;
        Pokemon pokemon = new Pokemon();
        pokemon.setSpecies(Objects.requireNonNull(PokemonSpecies.INSTANCE.getByName(chosenAlpha.getSpecies())));
        pokemon.setLevel(chosenAlpha.getLevelFromRange());
        pokemon.initializeMoveset(true);
        float baseSize = (float)ModConfig.alphaSizeMultiplier;
        pokemon = pokemon.clone(true, (RegistryAccess)RegistryAccess.EMPTY);
        pokemon.setScaleModifier((float)ModConfig.alphaSizeMultiplier);
        pokemon.getAspects().add("alpha");
        pokemon.getPersistentData().putBoolean("IS_ALPHA", true);
        pokemon.setScaleModifier(baseSize);
        IVs ivs = pokemon.getIvs();
        pokemon.setIvs$common(AlphaGenerator.maximizeRandomIVs(ivs, ModConfig.maximumBestIVs));
        pokemon.setAbility$common(AlphaGenerator.doHiddenAbilityCheck(pokemon));
        if (RNG.nextDouble() < 1.0 / (double)ModConfig.shinyOdds) {
            pokemon.setShiny(true);
        }
        if ((alphaEntity = (PokemonEntity)CobblemonEntities.POKEMON.create(spawnLevel)) != null) {
            alphaEntity.setPokemon(pokemon);
            alphaEntity.setDespawner((Despawner)AlphaDespawner.getInstance());
            alphaEntity.setPos((double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ());
            spawnLevel.getChunkAt(new BlockPos(spawnPos));
            return alphaEntity;
        }
        return null;
    }

    private static Ability doHiddenAbilityCheck(Pokemon pokemon) {
        AbilityPool abilities = pokemon.getSpecies().getAbilities();
        ArrayList<AbilityTemplate> hiddenAbilities = new ArrayList<AbilityTemplate>();
        for (PotentialAbility potentialAbility : abilities) {
            if (potentialAbility.getPriority() != Priority.LOW) continue;
            hiddenAbilities.add(potentialAbility.getTemplate());
        }
        if (!hiddenAbilities.isEmpty() && Math.random() >= 0.6) {
            int selection = new Random().nextInt(hiddenAbilities.size());
            return new Ability((AbilityTemplate)hiddenAbilities.get(selection), false, Priority.NORMAL);
        }
        return pokemon.getAbility();
    }

    public static IVs maximizeRandomIVs(IVs ivs, int numIvs) {
        ArrayList<String> chosenStats = new ArrayList<String>(List.of(statNames));
        for (int i = 1; i <= numIvs; ++i) {
            int ivIndex = new Random().nextInt(chosenStats.size());
            String statName = (String)chosenStats.get(ivIndex);
            Stats stat = Stats.valueOf((String)statName);
            ivs.set((Stat)stat, 31);
            chosenStats.remove(statName);
        }
        return ivs;
    }
}

