/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.cudzer.cobblemonalphas.util.HerdUtils;
import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HerdMemberFleeGoal
extends Goal {
    private final PokemonEntity herdEntity;
    private final double speed;
    @Nullable
    private PokemonEntity alpha;
    private double x;
    private double y;
    private double z;

    public HerdMemberFleeGoal(PokemonEntity herdEntity, double speedModifier) {
        this.herdEntity = herdEntity;
        this.speed = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.alpha = HerdUtils.findAlpha(this.herdEntity);
        if (this.alpha == null) {
            return false;
        }
        if (!this.alpha.isBattling()) {
            return false;
        }
        return this.findRandomPosition();
    }

    public boolean canContinueToUse() {
        return this.alpha != null && this.alpha.isBattling() && !this.herdEntity.getNavigation().isDone();
    }

    public void start() {
        this.herdEntity.getNavigation().moveTo(this.x, this.y, this.z, this.speed);
    }

    public void stop() {
        this.alpha = null;
    }

    private boolean findRandomPosition() {
        Vec3 pos = DefaultRandomPos.getPos((PathfinderMob)this.herdEntity, (int)12, (int)6);
        if (pos == null) {
            return false;
        }
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        return true;
    }
}

