/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.cudzer.cobblemonalphas.util.HerdUtils;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class HerdMemberRegroupGoal
extends Goal {
    private final PokemonEntity herdEntity;
    private PokemonEntity alphaEntity;
    private int pathCooldown = 0;

    public HerdMemberRegroupGoal(PokemonEntity herdMember) {
        this.herdEntity = herdMember;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.alphaEntity = HerdUtils.findAlpha(this.herdEntity);
        if (this.alphaEntity == null) {
            return false;
        }
        if (this.alphaEntity.isBattling()) {
            return false;
        }
        double distSq = this.herdEntity.distanceToSqr((Entity)this.alphaEntity);
        return !(distSq < 20.0);
    }

    public boolean canContinueToUse() {
        if (this.alphaEntity == null) {
            return false;
        }
        if (!this.alphaEntity.isAlive()) {
            return false;
        }
        if (this.alphaEntity.isBattling()) {
            return false;
        }
        double distSq = this.herdEntity.distanceToSqr((Entity)this.alphaEntity);
        return distSq > 16.0;
    }

    public void start() {
        this.pathCooldown = 0;
    }

    public void tick() {
        if (--this.pathCooldown <= 0) {
            this.pathCooldown = 10;
            this.herdEntity.getNavigation().moveTo((Entity)this.alphaEntity, 1.2);
        }
    }

    public void stop() {
        this.alphaEntity = null;
    }
}

