/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.cudzer.cobblemonalphas.util.HerdUtils;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class PokemonFollowAlphaGoal
extends Goal {
    private final PokemonEntity herdEntity;
    private PokemonEntity alphaEntity;
    private int recalcTimer = 0;

    public PokemonFollowAlphaGoal(PokemonEntity herd) {
        this.herdEntity = herd;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.alphaEntity = HerdUtils.findAlpha(this.herdEntity);
        if (this.alphaEntity == null) {
            return false;
        }
        if (this.alphaEntity.isBattling()) {
            return false;
        }
        double dist = this.herdEntity.distanceToSqr((Entity)this.alphaEntity);
        return dist > 9.0 && dist < 256.0;
    }

    public boolean canContinueToUse() {
        if (this.alphaEntity == null || !this.alphaEntity.isAlive()) {
            return false;
        }
        if (this.alphaEntity.isBattling()) {
            return false;
        }
        double dist = this.herdEntity.distanceToSqr((Entity)this.alphaEntity);
        return dist > 9.0 && dist < 256.0;
    }

    public void start() {
        this.recalcTimer = 0;
    }

    public void stop() {
        this.alphaEntity = null;
    }

    public void tick() {
        if (--this.recalcTimer <= 0) {
            this.recalcTimer = 10;
            this.herdEntity.getNavigation().moveTo((Entity)this.alphaEntity, 1.1);
        }
    }
}

