/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.particles;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.effect.SpawnSnowstormEntityParticlePacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class AlphaParticleEffect {
    private static final ResourceLocation ALPHA_PARTICLE = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"alpha_burst");
    private static final ResourceLocation ALPHA_AURA = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"alpha_aura");
    private static final ResourceLocation WILD_MIGHT = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"wild_might");
    private static final ResourceLocation ALPHA_NEARBY_SOUND = ResourceLocation.fromNamespaceAndPath((String)"cobblemonalphas", (String)"alpha_spawn");
    private static final ResourceLocation ALPHA_MIGHT_SOUND = ResourceLocation.fromNamespaceAndPath((String)"cobblemonalphas", (String)"wild_might");
    private static final Map<UUID, Long> alphaAmbientTimer = new HashMap<UUID, Long>();
    private static final double particleDistance = 26.0;
    private static final int particleInterval = 20000;

    public static void tick(MinecraftServer server) {
        List players = server.getPlayerList().getPlayers();
        server.getAllLevels().forEach(level -> level.getAllEntities().forEach(entity -> {
            Long startTime;
            PokemonEntity pokemonEntity;
            if (!(entity instanceof PokemonEntity) || !(pokemonEntity = (PokemonEntity)entity).getPokemon().getPersistentData().getBoolean("IS_ALPHA")) {
                return;
            }
            if (pokemonEntity.isBattling()) {
                if (pokemonEntity.getPokemon().getPersistentData().getBoolean("SUPER_ALPHA")) {
                    AlphaParticleEffect.superAura(pokemonEntity);
                } else {
                    AlphaParticleEffect.aura(pokemonEntity);
                }
            }
            boolean inRange = players.stream().anyMatch(player -> player.distanceToSqr((Entity)pokemonEntity) <= 676.0);
            ServerPlayer lookingAtAlpha = players.stream().filter(player -> pokemonEntity.getPokemon().isWild() && player.hasLineOfSight((Entity)pokemonEntity)).findFirst().orElse(null);
            if (!inRange) {
                return;
            }
            if (!(!pokemonEntity.getPokemon().isWild() || pokemonEntity.isBattling() || pokemonEntity.isBusy() || lookingAtAlpha == null || (startTime = alphaAmbientTimer.get(pokemonEntity.getUUID())) != null && System.currentTimeMillis() - startTime < 20000L)) {
                AlphaParticleEffect.spawnParticles(pokemonEntity);
                alphaAmbientTimer.put(pokemonEntity.getUUID(), System.currentTimeMillis());
            }
        }));
    }

    public static void wildMight(PokemonEntity entity) {
        List<String> locator = List.of("root");
        SpawnSnowstormEntityParticlePacket packet = new SpawnSnowstormEntityParticlePacket(WILD_MIGHT, entity.getId(), locator, Integer.valueOf(entity.getId()), List.of());
        packet.sendToPlayersAround(entity.getX(), entity.getY(), entity.getZ(), 64.0, Level.OVERWORLD, player -> false);
        SoundEvent sound = SoundEvent.createFixedRangeEvent((ResourceLocation)ALPHA_MIGHT_SOUND, (float)64.0f);
        entity.level().playSound((Entity)entity, entity.blockPosition(), sound, SoundSource.NEUTRAL, 2.0f, 1.0f);
    }

    public static void aura(PokemonEntity entity) {
        List<String> locator = List.of("root");
        SpawnSnowstormEntityParticlePacket packet = new SpawnSnowstormEntityParticlePacket(ALPHA_AURA, entity.getId(), locator, Integer.valueOf(entity.getId()), List.of());
        packet.sendToPlayersAround(entity.getX(), entity.getY(), entity.getZ(), 64.0, Level.OVERWORLD, player -> false);
    }

    public static void superAura(PokemonEntity entity) {
        List<String> locator = List.of("root");
        SpawnSnowstormEntityParticlePacket packet = new SpawnSnowstormEntityParticlePacket(ALPHA_AURA, entity.getId(), locator, Integer.valueOf(entity.getId()), List.of());
        packet.sendToPlayersAround(entity.getX(), entity.getY(), entity.getZ(), 64.0, Level.OVERWORLD, player -> false);
    }

    public static void spawnParticles(PokemonEntity entity) {
        List<String> locator = List.of("root");
        SpawnSnowstormEntityParticlePacket packet = new SpawnSnowstormEntityParticlePacket(ALPHA_PARTICLE, entity.getId(), locator, Integer.valueOf(entity.getId()), List.of());
        packet.sendToPlayersAround(entity.getX(), entity.getY(), entity.getZ(), 64.0, Level.OVERWORLD, player -> false);
        SoundEvent sound = SoundEvent.createFixedRangeEvent((ResourceLocation)ALPHA_NEARBY_SOUND, (float)64.0f);
        entity.level().playSound((Entity)entity, entity.blockPosition(), sound, SoundSource.NEUTRAL, 2.0f, 1.0f);
    }
}

