/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.util.Locale;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;

public interface MeasurementUnit {
    @ApiStatus.Internal
    public static final String NONE = "none";

    @NotNull
    public String name();

    @ApiStatus.Internal
    @NotNull
    default public String apiName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static final class Custom
    implements MeasurementUnit {
        @NotNull
        private final String name;

        public Custom(@NotNull String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String name() {
            return this.name;
        }
    }

    public static enum Fraction implements MeasurementUnit
    {
        RATIO,
        PERCENT;

    }

    public static enum Information implements MeasurementUnit
    {
        BIT,
        BYTE,
        KILOBYTE,
        KIBIBYTE,
        MEGABYTE,
        MEBIBYTE,
        GIGABYTE,
        GIBIBYTE,
        TERABYTE,
        TEBIBYTE,
        PETABYTE,
        PEBIBYTE,
        EXABYTE,
        EXBIBYTE;

    }

    public static enum Duration implements MeasurementUnit
    {
        NANOSECOND,
        MICROSECOND,
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK;

    }
}

