/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import me.xemor.sentry.BaggageHeader;
import me.xemor.sentry.Breadcrumb;
import me.xemor.sentry.CustomSamplingContext;
import me.xemor.sentry.Dsn;
import me.xemor.sentry.ExternalOptions;
import me.xemor.sentry.Hint;
import me.xemor.sentry.Hub;
import me.xemor.sentry.HubAdapter;
import me.xemor.sentry.IHub;
import me.xemor.sentry.ILogger;
import me.xemor.sentry.IOptionsObserver;
import me.xemor.sentry.ISentryClient;
import me.xemor.sentry.ISentryExecutorService;
import me.xemor.sentry.ISpan;
import me.xemor.sentry.ITransaction;
import me.xemor.sentry.Integration;
import me.xemor.sentry.JavaMemoryCollector;
import me.xemor.sentry.NoOpHub;
import me.xemor.sentry.NoOpLogger;
import me.xemor.sentry.OptionsContainer;
import me.xemor.sentry.PreviousSessionFinalizer;
import me.xemor.sentry.ScopeCallback;
import me.xemor.sentry.SentryEvent;
import me.xemor.sentry.SentryExecutorService;
import me.xemor.sentry.SentryLevel;
import me.xemor.sentry.SentryOptions;
import me.xemor.sentry.SentryTraceHeader;
import me.xemor.sentry.SystemOutLogger;
import me.xemor.sentry.TransactionContext;
import me.xemor.sentry.TransactionOptions;
import me.xemor.sentry.UserFeedback;
import me.xemor.sentry.cache.EnvelopeCache;
import me.xemor.sentry.cache.IEnvelopeCache;
import me.xemor.sentry.config.PropertiesProviderFactory;
import me.xemor.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import me.xemor.sentry.internal.debugmeta.ResourcesDebugMetaLoader;
import me.xemor.sentry.internal.modules.CompositeModulesLoader;
import me.xemor.sentry.internal.modules.IModulesLoader;
import me.xemor.sentry.internal.modules.ManifestModulesLoader;
import me.xemor.sentry.internal.modules.NoOpModulesLoader;
import me.xemor.sentry.internal.modules.ResourcesModulesLoader;
import me.xemor.sentry.protocol.SentryId;
import me.xemor.sentry.protocol.User;
import me.xemor.sentry.transport.NoOpEnvelopeCache;
import me.xemor.sentry.util.DebugMetaPropertiesApplier;
import me.xemor.sentry.util.FileUtils;
import me.xemor.sentry.util.thread.IMainThreadChecker;
import me.xemor.sentry.util.thread.MainThreadChecker;
import me.xemor.sentry.util.thread.NoOpMainThreadChecker;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

public final class Sentry {
    @NotNull
    private static final ThreadLocal<IHub> currentHub = new ThreadLocal();
    @NotNull
    private static volatile IHub mainHub = NoOpHub.getInstance();
    private static final boolean GLOBAL_HUB_DEFAULT_MODE = false;
    private static volatile boolean globalHubMode = false;

    private Sentry() {
    }

    @ApiStatus.Internal
    @NotNull
    public static IHub getCurrentHub() {
        if (globalHubMode) {
            return mainHub;
        }
        IHub hub = currentHub.get();
        if (hub == null || hub instanceof NoOpHub) {
            hub = mainHub.clone();
            currentHub.set(hub);
        }
        return hub;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public static IHub cloneMainHub() {
        if (globalHubMode) {
            return mainHub;
        }
        return mainHub.clone();
    }

    @ApiStatus.Internal
    public static void setCurrentHub(@NotNull IHub hub) {
        currentHub.set(hub);
    }

    public static boolean isEnabled() {
        return Sentry.getCurrentHub().isEnabled();
    }

    public static void init() {
        Sentry.init((SentryOptions options) -> options.setEnableExternalConfiguration(true), false);
    }

    public static void init(@NotNull String dsn) {
        Sentry.init((SentryOptions options) -> options.setDsn(dsn));
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Sentry.init(clazz, optionsConfiguration, false);
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration, boolean globalHubMode) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        SentryOptions options = (SentryOptions)clazz.createInstance();
        Sentry.applyOptionsConfiguration(optionsConfiguration, options);
        Sentry.init(options, globalHubMode);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration) {
        Sentry.init(optionsConfiguration, false);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration, boolean globalHubMode) {
        SentryOptions options = new SentryOptions();
        Sentry.applyOptionsConfiguration(optionsConfiguration, options);
        Sentry.init(options, globalHubMode);
    }

    private static <T extends SentryOptions> void applyOptionsConfiguration(OptionsConfiguration<T> optionsConfiguration, T options) {
        try {
            optionsConfiguration.configure(options);
        }
        catch (Throwable t) {
            options.getLogger().log(SentryLevel.ERROR, "Error in the 'OptionsConfiguration.configure' callback.", t);
        }
    }

    @ApiStatus.Internal
    public static void init(@NotNull SentryOptions options) {
        Sentry.init(options, false);
    }

    private static synchronized void init(@NotNull SentryOptions options, boolean globalHubMode) {
        if (Sentry.isEnabled()) {
            options.getLogger().log(SentryLevel.WARNING, "Sentry has been already initialized. Previous configuration will be overwritten.", new Object[0]);
        }
        if (!Sentry.initConfigurations(options)) {
            return;
        }
        options.getLogger().log(SentryLevel.INFO, "GlobalHubMode: '%s'", String.valueOf(globalHubMode));
        Sentry.globalHubMode = globalHubMode;
        IHub hub = Sentry.getCurrentHub();
        mainHub = new Hub(options);
        currentHub.set(mainHub);
        hub.close();
        ISentryExecutorService sentryExecutorService = options.getExecutorService();
        if (sentryExecutorService.isClosed()) {
            options.setExecutorService(new SentryExecutorService());
        }
        for (Integration integration : options.getIntegrations()) {
            integration.register(HubAdapter.getInstance(), options);
        }
        Sentry.notifyOptionsObservers(options);
        Sentry.finalizePreviousSession(options, HubAdapter.getInstance());
    }

    private static void finalizePreviousSession(@NotNull SentryOptions options, @NotNull IHub hub) {
        try {
            options.getExecutorService().submit(new PreviousSessionFinalizer(options, hub));
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.DEBUG, "Failed to finalize previous session.", e);
        }
    }

    private static void notifyOptionsObservers(@NotNull SentryOptions options) {
        try {
            options.getExecutorService().submit(() -> {
                for (IOptionsObserver observer : options.getOptionsObservers()) {
                    observer.setRelease(options.getRelease());
                    observer.setProguardUuid(options.getProguardUuid());
                    observer.setSdkVersion(options.getSdkVersion());
                    observer.setDist(options.getDist());
                    observer.setEnvironment(options.getEnvironment());
                    observer.setTags(options.getTags());
                }
            });
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.DEBUG, "Failed to notify options observers.", e);
        }
    }

    private static boolean initConfigurations(@NotNull SentryOptions options) {
        IModulesLoader modulesLoader;
        if (options.isEnableExternalConfiguration()) {
            options.merge(ExternalOptions.from(PropertiesProviderFactory.create(), options.getLogger()));
        }
        String dsn = options.getDsn();
        if (!options.isEnabled() || dsn != null && dsn.isEmpty()) {
            Sentry.close();
            return false;
        }
        if (dsn == null) {
            throw new IllegalArgumentException("DSN is required. Use empty string or set enabled to false in SentryOptions to disable SDK.");
        }
        Dsn parsedDsn = new Dsn(dsn);
        ILogger logger = options.getLogger();
        if (options.isDebug() && logger instanceof NoOpLogger) {
            options.setLogger(new SystemOutLogger());
            logger = options.getLogger();
        }
        logger.log(SentryLevel.INFO, "Initializing SDK with DSN: '%s'", options.getDsn());
        String outboxPath = options.getOutboxPath();
        if (outboxPath != null) {
            File outboxDir = new File(outboxPath);
            outboxDir.mkdirs();
        } else {
            logger.log(SentryLevel.INFO, "No outbox dir path is defined in options.", new Object[0]);
        }
        String cacheDirPath = options.getCacheDirPath();
        if (cacheDirPath != null) {
            File cacheDir = new File(cacheDirPath);
            cacheDir.mkdirs();
            IEnvelopeCache envelopeCache = options.getEnvelopeDiskCache();
            if (envelopeCache instanceof NoOpEnvelopeCache) {
                options.setEnvelopeDiskCache(EnvelopeCache.create(options));
            }
        }
        String profilingTracesDirPath = options.getProfilingTracesDirPath();
        if (options.isProfilingEnabled() && profilingTracesDirPath != null) {
            File profilingTracesDir = new File(profilingTracesDirPath);
            profilingTracesDir.mkdirs();
            File[] oldTracesDirContent = profilingTracesDir.listFiles();
            try {
                options.getExecutorService().submit(() -> {
                    if (oldTracesDirContent == null) {
                        return;
                    }
                    for (File f : oldTracesDirContent) {
                        FileUtils.deleteRecursively(f);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Old profiles will not be deleted. Did you call Sentry.close()?", e);
            }
        }
        if ((modulesLoader = options.getModulesLoader()) instanceof NoOpModulesLoader) {
            options.setModulesLoader(new CompositeModulesLoader(Arrays.asList(new ManifestModulesLoader(options.getLogger()), new ResourcesModulesLoader(options.getLogger())), options.getLogger()));
        }
        if (options.getDebugMetaLoader() instanceof NoOpDebugMetaLoader) {
            options.setDebugMetaLoader(new ResourcesDebugMetaLoader(options.getLogger()));
        }
        @Nullable Properties properties = options.getDebugMetaLoader().loadDebugMeta();
        DebugMetaPropertiesApplier.applyToOptions(options, properties);
        IMainThreadChecker mainThreadChecker = options.getMainThreadChecker();
        if (mainThreadChecker instanceof NoOpMainThreadChecker) {
            options.setMainThreadChecker(MainThreadChecker.getInstance());
        }
        if (options.getCollectors().isEmpty()) {
            options.addCollector(new JavaMemoryCollector());
        }
        return true;
    }

    public static synchronized void close() {
        IHub hub = Sentry.getCurrentHub();
        mainHub = NoOpHub.getInstance();
        currentHub.remove();
        hub.close();
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event) {
        return Sentry.getCurrentHub().captureEvent(event);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureEvent(event, callback);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event, @Nullable Hint hint) {
        return Sentry.getCurrentHub().captureEvent(event, hint);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureEvent(event, hint, callback);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message) {
        return Sentry.getCurrentHub().captureMessage(message);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureMessage(message, callback);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level) {
        return Sentry.getCurrentHub().captureMessage(message, level);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureMessage(message, level, callback);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable) {
        return Sentry.getCurrentHub().captureException(throwable);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureException(throwable, callback);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint) {
        return Sentry.getCurrentHub().captureException(throwable, hint);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureException(throwable, hint, callback);
    }

    public static void captureUserFeedback(@NotNull UserFeedback userFeedback) {
        Sentry.getCurrentHub().captureUserFeedback(userFeedback);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb, @Nullable Hint hint) {
        Sentry.getCurrentHub().addBreadcrumb(breadcrumb, hint);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        Sentry.getCurrentHub().addBreadcrumb(breadcrumb);
    }

    public static void addBreadcrumb(@NotNull String message) {
        Sentry.getCurrentHub().addBreadcrumb(message);
    }

    public static void addBreadcrumb(@NotNull String message, @NotNull String category) {
        Sentry.getCurrentHub().addBreadcrumb(message, category);
    }

    public static void setLevel(@Nullable SentryLevel level) {
        Sentry.getCurrentHub().setLevel(level);
    }

    public static void setTransaction(@Nullable String transaction) {
        Sentry.getCurrentHub().setTransaction(transaction);
    }

    public static void setUser(@Nullable User user) {
        Sentry.getCurrentHub().setUser(user);
    }

    public static void setFingerprint(@NotNull List<String> fingerprint) {
        Sentry.getCurrentHub().setFingerprint(fingerprint);
    }

    public static void clearBreadcrumbs() {
        Sentry.getCurrentHub().clearBreadcrumbs();
    }

    public static void setTag(@NotNull String key, @NotNull String value) {
        Sentry.getCurrentHub().setTag(key, value);
    }

    public static void removeTag(@NotNull String key) {
        Sentry.getCurrentHub().removeTag(key);
    }

    public static void setExtra(@NotNull String key, @NotNull String value) {
        Sentry.getCurrentHub().setExtra(key, value);
    }

    public static void removeExtra(@NotNull String key) {
        Sentry.getCurrentHub().removeExtra(key);
    }

    @NotNull
    public static SentryId getLastEventId() {
        return Sentry.getCurrentHub().getLastEventId();
    }

    public static void pushScope() {
        if (!globalHubMode) {
            Sentry.getCurrentHub().pushScope();
        }
    }

    public static void popScope() {
        if (!globalHubMode) {
            Sentry.getCurrentHub().popScope();
        }
    }

    public static void withScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentHub().withScope(callback);
    }

    public static void configureScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentHub().configureScope(callback);
    }

    public static void bindClient(@NotNull ISentryClient client) {
        Sentry.getCurrentHub().bindClient(client);
    }

    public static void flush(long timeoutMillis) {
        Sentry.getCurrentHub().flush(timeoutMillis);
    }

    public static void startSession() {
        Sentry.getCurrentHub().startSession();
    }

    public static void endSession() {
        Sentry.getCurrentHub().endSession();
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation) {
        return Sentry.getCurrentHub().startTransaction(name, operation);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, boolean bindToScope) {
        return Sentry.getCurrentHub().startTransaction(name, operation, bindToScope);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @Nullable String description) {
        return Sentry.startTransaction(name, operation, description, false);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @Nullable String description, boolean bindToScope) {
        ITransaction transaction = Sentry.getCurrentHub().startTransaction(name, operation, bindToScope);
        transaction.setDescription(description);
        return transaction;
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts) {
        return Sentry.getCurrentHub().startTransaction(transactionContexts);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts, boolean bindToScope) {
        return Sentry.getCurrentHub().startTransaction(transactionContexts, bindToScope);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @NotNull CustomSamplingContext customSamplingContext) {
        return Sentry.getCurrentHub().startTransaction(name, operation, customSamplingContext);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @NotNull CustomSamplingContext customSamplingContext, boolean bindToScope) {
        return Sentry.getCurrentHub().startTransaction(name, operation, customSamplingContext, bindToScope);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts, @NotNull CustomSamplingContext customSamplingContext) {
        return Sentry.getCurrentHub().startTransaction(transactionContexts, customSamplingContext);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts, @Nullable CustomSamplingContext customSamplingContext, boolean bindToScope) {
        return Sentry.getCurrentHub().startTransaction(transactionContexts, customSamplingContext, bindToScope);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContext, @NotNull TransactionOptions transactionOptions) {
        return Sentry.getCurrentHub().startTransaction(transactionContext, transactionOptions);
    }

    @Deprecated
    @Nullable
    public static SentryTraceHeader traceHeaders() {
        return Sentry.getCurrentHub().traceHeaders();
    }

    @Nullable
    public static ISpan getSpan() {
        return Sentry.getCurrentHub().getSpan();
    }

    @Nullable
    public static Boolean isCrashedLastRun() {
        return Sentry.getCurrentHub().isCrashedLastRun();
    }

    public static void reportFullyDisplayed() {
        Sentry.getCurrentHub().reportFullyDisplayed();
    }

    @Deprecated
    public static void reportFullDisplayed() {
        Sentry.reportFullyDisplayed();
    }

    @Nullable
    public static TransactionContext continueTrace(@Nullable String sentryTrace, @Nullable List<String> baggageHeaders) {
        return Sentry.getCurrentHub().continueTrace(sentryTrace, baggageHeaders);
    }

    @Nullable
    public static SentryTraceHeader getTraceparent() {
        return Sentry.getCurrentHub().getTraceparent();
    }

    @Nullable
    public static BaggageHeader getBaggage() {
        return Sentry.getCurrentHub().getBaggage();
    }

    public static interface OptionsConfiguration<T extends SentryOptions> {
        public void configure(@NotNull T var1);
    }
}

