/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.io.File;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import me.xemor.superheroes.org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryCrashLastRunState {
    private static final SentryCrashLastRunState INSTANCE = new SentryCrashLastRunState();
    private boolean readCrashedLastRun;
    @Nullable
    private Boolean crashedLastRun;
    @NotNull
    private final Object crashedLastRunLock = new Object();

    private SentryCrashLastRunState() {
    }

    public static SentryCrashLastRunState getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Boolean isCrashedLastRun(@Nullable String cacheDirPath, boolean deleteFile) {
        Object object = this.crashedLastRunLock;
        synchronized (object) {
            if (this.readCrashedLastRun) {
                return this.crashedLastRun;
            }
            if (cacheDirPath == null) {
                return null;
            }
            this.readCrashedLastRun = true;
            File javaMarker = new File(cacheDirPath, "last_crash");
            File nativeMarker = new File(cacheDirPath, ".sentry-native/last_crash");
            boolean exists = false;
            try {
                if (javaMarker.exists()) {
                    exists = true;
                    javaMarker.delete();
                } else if (nativeMarker.exists()) {
                    exists = true;
                    if (deleteFile) {
                        nativeMarker.delete();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.crashedLastRun = exists;
        }
        return this.crashedLastRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrashedLastRun(boolean crashedLastRun) {
        Object object = this.crashedLastRunLock;
        synchronized (object) {
            if (!this.readCrashedLastRun) {
                this.crashedLastRun = crashedLastRun;
                this.readCrashedLastRun = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void reset() {
        Object object = this.crashedLastRunLock;
        synchronized (object) {
            this.readCrashedLastRun = false;
            this.crashedLastRun = null;
        }
    }
}

