/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.xemor.sentry.SentryOptions;
import me.xemor.sentry.SentryStackTraceFactory;
import me.xemor.sentry.protocol.SentryStackFrame;
import me.xemor.sentry.protocol.SentryStackTrace;
import me.xemor.sentry.protocol.SentryThread;
import me.xemor.sentry.util.Objects;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import me.xemor.superheroes.org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryThreadFactory {
    @NotNull
    private final SentryStackTraceFactory sentryStackTraceFactory;
    @NotNull
    private final SentryOptions options;

    public SentryThreadFactory(@NotNull SentryStackTraceFactory sentryStackTraceFactory, @NotNull SentryOptions options) {
        this.sentryStackTraceFactory = Objects.requireNonNull(sentryStackTraceFactory, "The SentryStackTraceFactory is required.");
        this.options = Objects.requireNonNull(options, "The SentryOptions is required");
    }

    @Nullable
    List<SentryThread> getCurrentThread() {
        HashMap<Thread, StackTraceElement[]> threads = new HashMap<Thread, StackTraceElement[]>();
        Thread currentThread = Thread.currentThread();
        threads.put(currentThread, currentThread.getStackTrace());
        return this.getCurrentThreads(threads, null, false);
    }

    @Nullable
    List<SentryThread> getCurrentThreads(@Nullable List<Long> mechanismThreadIds, boolean ignoreCurrentThread) {
        return this.getCurrentThreads(Thread.getAllStackTraces(), mechanismThreadIds, ignoreCurrentThread);
    }

    @Nullable
    List<SentryThread> getCurrentThreads(@Nullable List<Long> mechanismThreadIds) {
        return this.getCurrentThreads(Thread.getAllStackTraces(), mechanismThreadIds, false);
    }

    @TestOnly
    @Nullable
    List<SentryThread> getCurrentThreads(@NotNull Map<Thread, StackTraceElement[]> threads, @Nullable List<Long> mechanismThreadIds, boolean ignoreCurrentThread) {
        ArrayList<SentryThread> result = null;
        Thread currentThread = Thread.currentThread();
        if (!threads.isEmpty()) {
            result = new ArrayList<SentryThread>();
            if (!threads.containsKey(currentThread)) {
                threads.put(currentThread, currentThread.getStackTrace());
            }
            for (Map.Entry<Thread, StackTraceElement[]> item : threads.entrySet()) {
                Thread thread = item.getKey();
                boolean crashed = thread == currentThread && !ignoreCurrentThread || mechanismThreadIds != null && mechanismThreadIds.contains(thread.getId());
                result.add(this.getSentryThread(crashed, item.getValue(), item.getKey()));
            }
        }
        return result;
    }

    @NotNull
    private SentryThread getSentryThread(boolean crashed, @NotNull StackTraceElement[] stackFramesElements, @NotNull Thread thread) {
        SentryThread sentryThread = new SentryThread();
        sentryThread.setName(thread.getName());
        sentryThread.setPriority(thread.getPriority());
        sentryThread.setId(thread.getId());
        sentryThread.setDaemon(thread.isDaemon());
        sentryThread.setState(thread.getState().name());
        sentryThread.setCrashed(crashed);
        List<SentryStackFrame> frames = this.sentryStackTraceFactory.getStackFrames(stackFramesElements);
        if (this.options.isAttachStacktrace() && frames != null && !frames.isEmpty()) {
            SentryStackTrace sentryStackTrace = new SentryStackTrace(frames);
            sentryStackTrace.setSnapshot(true);
            sentryThread.setStacktrace(sentryStackTrace);
        }
        return sentryThread;
    }
}

