/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.io.Closeable;
import java.io.IOException;
import me.xemor.sentry.IHub;
import me.xemor.sentry.Integration;
import me.xemor.sentry.SentryLevel;
import me.xemor.sentry.SentryOptions;
import me.xemor.sentry.util.Objects;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import me.xemor.superheroes.org.jetbrains.annotations.TestOnly;
import me.xemor.superheroes.org.jetbrains.annotations.VisibleForTesting;

public final class ShutdownHookIntegration
implements Integration,
Closeable {
    @NotNull
    private final Runtime runtime;
    @Nullable
    private Thread thread;

    @TestOnly
    public ShutdownHookIntegration(@NotNull Runtime runtime) {
        this.runtime = Objects.requireNonNull(runtime, "Runtime is required");
    }

    public ShutdownHookIntegration() {
        this(Runtime.getRuntime());
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull(hub, "Hub is required");
        Objects.requireNonNull(options, "SentryOptions is required");
        if (options.isEnableShutdownHook()) {
            this.thread = new Thread(() -> hub.flush(options.getFlushTimeoutMillis()));
            this.runtime.addShutdownHook(this.thread);
            options.getLogger().log(SentryLevel.DEBUG, "ShutdownHookIntegration installed.", new Object[0]);
            this.addIntegrationToSdkVersion();
        } else {
            options.getLogger().log(SentryLevel.INFO, "enableShutdownHook is disabled.", new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        block3: {
            if (this.thread != null) {
                try {
                    this.runtime.removeShutdownHook(this.thread);
                }
                catch (IllegalStateException e) {
                    @Nullable String message = e.getMessage();
                    if (message != null && message.equals("Shutdown in progress")) break block3;
                    throw e;
                }
            }
        }
    }

    @VisibleForTesting
    @Nullable
    Thread getHook() {
        return this.thread;
    }
}

