/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.security.SecureRandom;
import me.xemor.sentry.SamplingContext;
import me.xemor.sentry.SentryLevel;
import me.xemor.sentry.SentryOptions;
import me.xemor.sentry.TracesSamplingDecision;
import me.xemor.sentry.util.Objects;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import me.xemor.superheroes.org.jetbrains.annotations.TestOnly;

final class TracesSampler {
    @NotNull
    private static final Double DEFAULT_TRACES_SAMPLE_RATE = 1.0;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SecureRandom random;

    public TracesSampler(@NotNull SentryOptions options) {
        this(Objects.requireNonNull(options, "options are required"), new SecureRandom());
    }

    @TestOnly
    TracesSampler(@NotNull SentryOptions options, @NotNull SecureRandom random) {
        this.options = options;
        this.random = random;
    }

    @NotNull
    TracesSamplingDecision sample(@NotNull SamplingContext samplingContext) {
        Double tracesSampleRateOrDefault;
        TracesSamplingDecision parentSamplingDecision;
        TracesSamplingDecision samplingContextSamplingDecision = samplingContext.getTransactionContext().getSamplingDecision();
        if (samplingContextSamplingDecision != null) {
            return samplingContextSamplingDecision;
        }
        Double profilesSampleRate = null;
        if (this.options.getProfilesSampler() != null) {
            try {
                profilesSampleRate = this.options.getProfilesSampler().sample(samplingContext);
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'ProfilesSamplerCallback' callback.", t);
            }
        }
        if (profilesSampleRate == null) {
            profilesSampleRate = this.options.getProfilesSampleRate();
        }
        Boolean profilesSampled = profilesSampleRate != null && this.sample(profilesSampleRate);
        if (this.options.getTracesSampler() != null) {
            Double samplerResult = null;
            try {
                samplerResult = this.options.getTracesSampler().sample(samplingContext);
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'TracesSamplerCallback' callback.", t);
            }
            if (samplerResult != null) {
                return new TracesSamplingDecision(this.sample(samplerResult), samplerResult, profilesSampled, profilesSampleRate);
            }
        }
        if ((parentSamplingDecision = samplingContext.getTransactionContext().getParentSamplingDecision()) != null) {
            return parentSamplingDecision;
        }
        @Nullable Double tracesSampleRateFromOptions = this.options.getTracesSampleRate();
        @Nullable Boolean isEnableTracing = this.options.getEnableTracing();
        Double defaultSampleRate = Boolean.TRUE.equals(isEnableTracing) ? DEFAULT_TRACES_SAMPLE_RATE : null;
        Double d = tracesSampleRateOrDefault = tracesSampleRateFromOptions == null ? defaultSampleRate : tracesSampleRateFromOptions;
        if (tracesSampleRateOrDefault != null) {
            return new TracesSamplingDecision(this.sample(tracesSampleRateOrDefault), tracesSampleRateOrDefault, profilesSampled, profilesSampleRate);
        }
        return new TracesSamplingDecision(false, null, false, null);
    }

    private boolean sample(@NotNull Double aDouble) {
        return !(aDouble < this.random.nextDouble());
    }
}

