/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry.protocol;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.xemor.sentry.ILogger;
import me.xemor.sentry.JsonDeserializer;
import me.xemor.sentry.JsonObjectReader;
import me.xemor.sentry.JsonSerializable;
import me.xemor.sentry.JsonUnknown;
import me.xemor.sentry.ObjectWriter;
import me.xemor.sentry.protocol.ViewHierarchyNode;
import me.xemor.sentry.vendor.gson.stream.JsonToken;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

public final class ViewHierarchy
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private final String renderingSystem;
    @Nullable
    private final List<ViewHierarchyNode> windows;
    @Nullable
    private Map<String, Object> unknown;

    public ViewHierarchy(@Nullable String renderingSystem, @Nullable List<ViewHierarchyNode> windows) {
        this.renderingSystem = renderingSystem;
        this.windows = windows;
    }

    @Nullable
    public String getRenderingSystem() {
        return this.renderingSystem;
    }

    @Nullable
    public List<ViewHierarchyNode> getWindows() {
        return this.windows;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        if (this.renderingSystem != null) {
            writer.name("rendering_system").value(this.renderingSystem);
        }
        if (this.windows != null) {
            writer.name("windows").value(logger, this.windows);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        writer.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String RENDERING_SYSTEM = "rendering_system";
        public static final String WINDOWS = "windows";
    }

    public static final class Deserializer
    implements JsonDeserializer<ViewHierarchy> {
        @Override
        @NotNull
        public ViewHierarchy deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            @Nullable String renderingSystem = null;
            List<ViewHierarchyNode> windows = null;
            HashMap<String, Object> unknown = null;
            reader.beginObject();
            block8: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "rendering_system": {
                        renderingSystem = reader.nextStringOrNull();
                        continue block8;
                    }
                    case "windows": {
                        windows = reader.nextList(logger, new ViewHierarchyNode.Deserializer());
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            reader.endObject();
            ViewHierarchy viewHierarchy = new ViewHierarchy(renderingSystem, windows);
            viewHierarchy.setUnknown(unknown);
            return viewHierarchy;
        }
    }
}

