/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerArray;
import me.xemor.sentry.ILogger;
import me.xemor.sentry.ISerializer;
import me.xemor.sentry.JsonSerializable;
import me.xemor.sentry.SentryLevel;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JsonSerializationUtils {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    @NotNull
    public static Map<String, Object> calendarToMap(@NotNull Calendar calendar) {
        @NotNull HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("year", calendar.get(1));
        map.put("month", calendar.get(2));
        map.put("dayOfMonth", calendar.get(5));
        map.put("hourOfDay", calendar.get(11));
        map.put("minute", calendar.get(12));
        map.put("second", calendar.get(13));
        return map;
    }

    @NotNull
    public static List<Object> atomicIntegerArrayToList(@NotNull AtomicIntegerArray array) {
        int numberOfItems = array.length();
        @NotNull ArrayList<Object> list = new ArrayList<Object>(numberOfItems);
        for (int i = 0; i < numberOfItems; ++i) {
            list.add(array.get(i));
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static byte[] bytesFrom(@NotNull ISerializer serializer, @NotNull ILogger logger, @NotNull JsonSerializable serializable) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, UTF_8));){
                serializer.serialize(serializable, writer);
                byArray = stream.toByteArray();
            }
            return byArray;
        }
        catch (Throwable t) {
            logger.log(SentryLevel.ERROR, "Could not serialize serializable", t);
            return null;
        }
    }
}

