/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.xemor.sentry.ISpan;
import me.xemor.sentry.protocol.Request;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class UrlUtils {
    @NotNull
    public static final String SENSITIVE_DATA_SUBSTITUTE = "[Filtered]";
    @NotNull
    private static final Pattern AUTH_REGEX = Pattern.compile("(.+://)(.*@)(.*)");

    @Nullable
    public static UrlDetails parseNullable(@Nullable String url) {
        if (url == null) {
            return null;
        }
        return UrlUtils.parse(url);
    }

    @NotNull
    public static UrlDetails parse(@NotNull String url) {
        if (UrlUtils.isAbsoluteUrl(url)) {
            return UrlUtils.splitAbsoluteUrl(url);
        }
        return UrlUtils.splitRelativeUrl(url);
    }

    private static boolean isAbsoluteUrl(@NotNull String url) {
        return url.contains("://");
    }

    @NotNull
    private static UrlDetails splitRelativeUrl(@NotNull String url) {
        int queryParamSeparatorIndex = url.indexOf("?");
        int fragmentSeparatorIndex = url.indexOf("#");
        @Nullable String baseUrl = UrlUtils.extractBaseUrl(url, queryParamSeparatorIndex, fragmentSeparatorIndex);
        @Nullable String query = UrlUtils.extractQuery(url, queryParamSeparatorIndex, fragmentSeparatorIndex);
        @Nullable String fragment = UrlUtils.extractFragment(url, fragmentSeparatorIndex);
        return new UrlDetails(baseUrl, query, fragment);
    }

    @Nullable
    private static String extractBaseUrl(@NotNull String url, int queryParamSeparatorIndex, int fragmentSeparatorIndex) {
        if (queryParamSeparatorIndex >= 0) {
            return url.substring(0, queryParamSeparatorIndex).trim();
        }
        if (fragmentSeparatorIndex >= 0) {
            return url.substring(0, fragmentSeparatorIndex).trim();
        }
        return url;
    }

    @Nullable
    private static String extractQuery(@NotNull String url, int queryParamSeparatorIndex, int fragmentSeparatorIndex) {
        if (queryParamSeparatorIndex > 0) {
            if (fragmentSeparatorIndex > 0 && fragmentSeparatorIndex > queryParamSeparatorIndex) {
                return url.substring(queryParamSeparatorIndex + 1, fragmentSeparatorIndex).trim();
            }
            return url.substring(queryParamSeparatorIndex + 1).trim();
        }
        return null;
    }

    @Nullable
    private static String extractFragment(@NotNull String url, int fragmentSeparatorIndex) {
        if (fragmentSeparatorIndex > 0) {
            return url.substring(fragmentSeparatorIndex + 1).trim();
        }
        return null;
    }

    @NotNull
    private static UrlDetails splitAbsoluteUrl(@NotNull String url) {
        try {
            @NotNull String filteredUrl = UrlUtils.urlWithAuthRemoved(url);
            @NotNull URL urlObj = new URL(url);
            @NotNull String baseUrl = UrlUtils.baseUrlOnly(filteredUrl);
            if (baseUrl.contains("#")) {
                return new UrlDetails(null, null, null);
            }
            @Nullable String query = urlObj.getQuery();
            @Nullable String fragment = urlObj.getRef();
            return new UrlDetails(baseUrl, query, fragment);
        }
        catch (MalformedURLException e) {
            return new UrlDetails(null, null, null);
        }
    }

    @NotNull
    private static String urlWithAuthRemoved(@NotNull String url) {
        @NotNull Matcher userInfoMatcher = AUTH_REGEX.matcher(url);
        if (userInfoMatcher.matches() && userInfoMatcher.groupCount() == 3) {
            @NotNull String userInfoString = userInfoMatcher.group(2);
            @NotNull String replacementString = userInfoString.contains(":") ? "[Filtered]:[Filtered]@" : "[Filtered]@";
            return userInfoMatcher.group(1) + replacementString + userInfoMatcher.group(3);
        }
        return url;
    }

    @NotNull
    private static String baseUrlOnly(@NotNull String url) {
        int queryParamSeparatorIndex = url.indexOf("?");
        if (queryParamSeparatorIndex >= 0) {
            return url.substring(0, queryParamSeparatorIndex).trim();
        }
        int fragmentSeparatorIndex = url.indexOf("#");
        if (fragmentSeparatorIndex >= 0) {
            return url.substring(0, fragmentSeparatorIndex).trim();
        }
        return url;
    }

    public static final class UrlDetails {
        @Nullable
        private final String url;
        @Nullable
        private final String query;
        @Nullable
        private final String fragment;

        public UrlDetails(@Nullable String url, @Nullable String query, @Nullable String fragment) {
            this.url = url;
            this.query = query;
            this.fragment = fragment;
        }

        @Nullable
        public String getUrl() {
            return this.url;
        }

        @NotNull
        public String getUrlOrFallback() {
            if (this.url == null) {
                return "unknown";
            }
            return this.url;
        }

        @Nullable
        public String getQuery() {
            return this.query;
        }

        @Nullable
        public String getFragment() {
            return this.fragment;
        }

        public void applyToRequest(@Nullable Request request) {
            if (request == null) {
                return;
            }
            request.setUrl(this.url);
            request.setQueryString(this.query);
            request.setFragment(this.fragment);
        }

        public void applyToSpan(@Nullable ISpan span) {
            if (span == null) {
                return;
            }
            if (this.query != null) {
                span.setData("http.query", this.query);
            }
            if (this.fragment != null) {
                span.setData("http.fragment", this.fragment);
            }
        }
    }
}

