/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes;

import java.util.HashMap;
import java.util.UUID;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.kyori.adventure.audience.Audience;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.md_5.bungee.api.ChatMessageType;
import org.bukkit.Bukkit;

public class CooldownHandler {
    private final HashMap<UUID, Long> cooldownMap = new HashMap();
    private final String cooldownMessage;
    private final ChatMessageType chatMessageType;

    public CooldownHandler(String cooldownMsg, ChatMessageType chatMessageType) {
        this.cooldownMessage = cooldownMsg;
        this.chatMessageType = chatMessageType;
    }

    public void startCooldown(double cooldown, UUID uuid) {
        this.cooldownMap.put(uuid, (long)(cooldown * 1000.0) + System.currentTimeMillis());
    }

    public boolean hasUsedItemBefore(UUID uuid) {
        return this.cooldownMap.containsKey(uuid);
    }

    public boolean isCooldownOver(UUID uuid) {
        return this.isCooldownOver(uuid, this.cooldownMessage);
    }

    public boolean isCooldownOver(UUID uuid, String cooldownMessage) {
        long seconds = this.getCurrentCooldown(uuid);
        if (!cooldownMessage.equals("") && seconds > 0L) {
            Component component = MiniMessage.miniMessage().deserialize(cooldownMessage, (TagResolver)Placeholder.unparsed("currentcooldown", String.valueOf(seconds)));
            Audience player = Superheroes.getBukkitAudiences().player(Bukkit.getPlayer((UUID)uuid));
            if (this.chatMessageType == ChatMessageType.ACTION_BAR) {
                player.sendActionBar(component);
            } else {
                player.sendMessage(component);
            }
        }
        return seconds <= 0L;
    }

    public long getCurrentCooldown(UUID uuid) {
        if (this.cooldownMap.containsKey(uuid)) {
            long timeAtCooldownStart = this.cooldownMap.get(uuid);
            if (timeAtCooldownStart <= System.currentTimeMillis()) {
                return 0L;
            }
            return (timeAtCooldownStart - System.currentTimeMillis()) / 1000L;
        }
        return 0L;
    }
}

