/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.xemor.superheroes.skills.skilldata.configdata.Cooldown;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SkillCooldownHandler {
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build();
    private final Map<Cooldown, HashMap<UUID, Long>> cooldownMap = new HashMap<Cooldown, HashMap<UUID, Long>>();

    public void startCooldown(Cooldown skillData, double cooldown, UUID uuid) {
        HashMap<UUID, Long> hashMap = this.cooldownMap.getOrDefault(skillData, new HashMap());
        hashMap.put(uuid, (long)(cooldown * 1000.0) + System.currentTimeMillis());
        this.cooldownMap.put(skillData, hashMap);
    }

    public void startCooldown(Cooldown skillData, UUID uuid) {
        this.startCooldown(skillData, skillData.getCooldown(), uuid);
    }

    public boolean isCooldownOver(Cooldown skillData, UUID uuid) {
        HashMap hashMap = this.cooldownMap.getOrDefault(skillData, new HashMap());
        if (hashMap.containsKey(uuid)) {
            if ((Long)hashMap.get(uuid) <= System.currentTimeMillis()) {
                return true;
            }
            long seconds = ((Long)hashMap.get(uuid) - System.currentTimeMillis()) / 1000L;
            Component cooldownMessage = MiniMessage.miniMessage().deserialize(skillData.getCooldownMessage(), (TagResolver)Placeholder.unparsed("currentcooldown", String.valueOf(seconds)));
            String serializedMessage = legacySerializer.serialize(cooldownMessage);
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)serializedMessage));
            }
            return false;
        }
        return true;
    }
}

