/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.xemor.superheroes.Skin;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.SoundData;
import me.xemor.superheroes.configurationdata.deserializers.ItemStackDeserializer;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.format.TextColor;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.xemor.superheroes.me.sepdron.headcreator.HeadCreator;
import me.xemor.superheroes.skills.PlusUltraSkillsContainer;
import me.xemor.superheroes.skills.Skill;
import me.xemor.superheroes.skills.SkillsContainer;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Superhero {
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build();
    @JsonProperty
    private String name;
    @JsonProperty
    private String colouredName;
    @JsonProperty
    private String description;
    @JsonPropertyWithDefault
    private SoundData heroGainedSound = null;
    @JsonPropertyWithDefault
    private Skin skin = null;
    @JsonPropertyWithDefault
    @JsonDeserialize(using=ItemStackDeserializer.class)
    private ItemStack icon = null;
    @JsonPropertyWithDefault
    private SkillsContainer skills = new SkillsContainer();
    @JsonPropertyWithDefault
    @JsonDeserialize(using=PlusUltraSkillsContainer.PlusUltraSkillsContainerDeserializer.class)
    private PlusUltraSkillsContainer plusUltraSkills = new PlusUltraSkillsContainer();

    public Superhero() {
    }

    public Superhero(String name, String colouredName, String description) {
        this.name = name;
        this.description = description;
        this.colouredName = colouredName;
    }

    public boolean hasSkill(String skill) {
        return this.getSkillsAndPlusUltraSkills().containsKey((Object)skill);
    }

    public Collection<SkillData> getSkillData(String skill) {
        return this.getSkillsAndPlusUltraSkills().get((Object)skill);
    }

    public <T extends SkillData> List<T> getSkillData(Class<T> skillClazz) {
        return this.getSkillsAndPlusUltraSkills().get((Object)Skill.getName(skillClazz)).stream().map(skillClazz::cast).toList();
    }

    public Collection<String> getSkills() {
        return this.getSkillsAndPlusUltraSkills().keys();
    }

    private Multimap<String, SkillData> getSkillsAndPlusUltraSkills() {
        Multimap<String, SkillData> skillMap = this.skills.getSkills();
        if (Superheroes.getInstance().hasPlusUltra()) {
            skillMap.putAll(this.plusUltraSkills.getSkillsContainer().getSkills());
        }
        return skillMap;
    }

    public String getBase64Skin() {
        if (this.skin == null) {
            return null;
        }
        return this.skin.value();
    }

    public String getSignature() {
        if (this.skin == null) {
            return null;
        }
        return this.skin.signature();
    }

    public String getPermission() {
        return "superheroes.hero." + this.name.toLowerCase();
    }

    public ItemStack getIcon() {
        if (this.icon == null) {
            Object colouredNameComponent = MiniMessage.miniMessage().deserialize(this.colouredName);
            this.icon = this.createSkullIcon().orElseGet(() -> this.createWoolIcon((Component)colouredNameComponent));
            ItemMeta meta = this.icon.getItemMeta();
            meta.setDisplayName(legacySerializer.serialize((Component)colouredNameComponent));
            Object descriptionComponent = MiniMessage.miniMessage().deserialize(this.description);
            descriptionComponent = descriptionComponent.colorIfAbsent(TextColor.color(255, 255, 255));
            meta.setLore(List.of(legacySerializer.serialize((Component)descriptionComponent)));
            this.icon.setItemMeta(meta);
        }
        return this.icon;
    }

    private ItemStack createWoolIcon(Component colouredName) {
        TextColor color = colouredName.color();
        if (color == null) {
            return new ItemStack(Material.BLACK_WOOL);
        }
        return new ItemStack(this.woolFromColor(color.red(), color.green(), color.blue()));
    }

    private Optional<ItemStack> createSkullIcon() {
        String base64Skin = this.getBase64Skin();
        if (base64Skin == null || base64Skin.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(HeadCreator.createFromBase64(base64Skin));
    }

    private Material woolFromColor(int red, int green, int blue) {
        int distance = Integer.MAX_VALUE;
        DyeColor closest = DyeColor.BLACK;
        for (DyeColor dye : DyeColor.values()) {
            Color color = dye.getColor();
            int dist = Math.abs(color.getRed() - red) + Math.abs(color.getGreen() - green) + Math.abs(color.getBlue() - blue);
            if (dist >= distance) continue;
            distance = dist;
            closest = dye;
        }
        return Material.getMaterial((String)(closest.name() + "_WOOL").toUpperCase());
    }

    public boolean equals(Object other) {
        if (other instanceof Superhero) {
            return this.name.equals(((Superhero)other).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getColouredName() {
        return this.colouredName == null ? this.name : this.colouredName;
    }

    public String getDescription() {
        return this.description;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public PlusUltraSkillsContainer getPlusUltraSkills() {
        return this.plusUltraSkills;
    }

    public SoundData getHeroGainedSound() {
        return this.heroGainedSound;
    }
}

