/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import me.xemor.skillslibrary2.conditions.Conditions;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.UpdateChecker;
import me.xemor.superheroes.WorldGuardSupport;
import me.xemor.superheroes.commands.HeroCommand;
import me.xemor.superheroes.conditions.SuperheroCondition;
import me.xemor.superheroes.configurationdata.ConfigurationData;
import me.xemor.superheroes.data.ConfigHandler;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.foliahacks.FoliaHacks;
import me.xemor.superheroes.kyori.adventure.platform.bukkit.BukkitAudiences;
import me.xemor.superheroes.lushplugins.unifiedprotection.bukkit.BukkitUnifiedProtection;
import me.xemor.superheroes.morepaperlib.scheduling.GracefulScheduling;
import me.xemor.superheroes.org.bstats.bukkit.Metrics;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.reroll.RerollHandler;
import me.xemor.superheroes.sentry.SentryInitializer;
import me.xemor.superheroes.skills.implementations.AttributeSkill;
import me.xemor.superheroes.skills.implementations.AuraSkill;
import me.xemor.superheroes.skills.implementations.BlockDropsSkill;
import me.xemor.superheroes.skills.implementations.BlockRaySkill;
import me.xemor.superheroes.skills.implementations.ClimbSkill;
import me.xemor.superheroes.skills.implementations.ConsumeSkill;
import me.xemor.superheroes.skills.implementations.ConvertBlockSkill;
import me.xemor.superheroes.skills.implementations.ConvertDropsSkill;
import me.xemor.superheroes.skills.implementations.ConvertItemSkill;
import me.xemor.superheroes.skills.implementations.CraftingSkill;
import me.xemor.superheroes.skills.implementations.CreeperSkill;
import me.xemor.superheroes.skills.implementations.DamageModifierSkill;
import me.xemor.superheroes.skills.implementations.DamagePotionSkill;
import me.xemor.superheroes.skills.implementations.DamageResistanceSkill;
import me.xemor.superheroes.skills.implementations.DecoySkill;
import me.xemor.superheroes.skills.implementations.EggLayerSkill;
import me.xemor.superheroes.skills.implementations.EraserSkill;
import me.xemor.superheroes.skills.implementations.FlightSkill;
import me.xemor.superheroes.skills.implementations.GiveItemSkill;
import me.xemor.superheroes.skills.implementations.GunSkill;
import me.xemor.superheroes.skills.implementations.HeartStealSkill;
import me.xemor.superheroes.skills.implementations.InstantBreak;
import me.xemor.superheroes.skills.implementations.KillPotionSkill;
import me.xemor.superheroes.skills.implementations.LifestealSkill;
import me.xemor.superheroes.skills.implementations.LightSkill;
import me.xemor.superheroes.skills.implementations.NoHungerSkill;
import me.xemor.superheroes.skills.implementations.OHKOSkill;
import me.xemor.superheroes.skills.implementations.PhaseSkill;
import me.xemor.superheroes.skills.implementations.PickpocketSkill;
import me.xemor.superheroes.skills.implementations.PotionEffectSkill;
import me.xemor.superheroes.skills.implementations.PotionGifterSkill;
import me.xemor.superheroes.skills.implementations.RemoteDetonationSkill;
import me.xemor.superheroes.skills.implementations.RepulsionSkill;
import me.xemor.superheroes.skills.implementations.ShieldSkill;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.implementations.SlamSkill;
import me.xemor.superheroes.skills.implementations.SlimeSkill;
import me.xemor.superheroes.skills.implementations.SneakSkill;
import me.xemor.superheroes.skills.implementations.SneakingPotionSkill;
import me.xemor.superheroes.skills.implementations.SpellSkill;
import me.xemor.superheroes.skills.implementations.StrongmanSkill;
import me.xemor.superheroes.skills.implementations.SummonSkill;
import me.xemor.superheroes.skills.implementations.TeleportSkill;
import me.xemor.superheroes.skills.implementations.ThrowerSkill;
import me.xemor.superheroes.skills.implementations.WalkerSkill;
import me.xemor.superheroes.skills.implementations.WeatherDamageSkill;
import me.xemor.userinterface.ChestHandler;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Superheroes
extends JavaPlugin
implements Listener {
    private ConfigHandler configHandler;
    private HeroHandler heroHandler;
    private RerollHandler rerollHandler;
    private static BukkitAudiences bukkitAudiences;
    private boolean hasSkillsLibrary;
    private static Superheroes superheroes;
    private WorldGuardSupport worldGuardSupport;
    private static FoliaHacks foliaHacks;
    private static BukkitUnifiedProtection unifiedProtection;

    public static Superheroes getInstance() {
        return superheroes;
    }

    public static BukkitAudiences getBukkitAudiences() {
        return bukkitAudiences;
    }

    public static GracefulScheduling getScheduling() {
        return foliaHacks.getScheduling();
    }

    public static FoliaHacks getFoliaHacks() {
        return foliaHacks;
    }

    public static BukkitUnifiedProtection getUnifiedProtection() {
        return unifiedProtection;
    }

    public void onLoad() {
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            WorldGuardSupport.setupFlag();
        }
    }

    public void onEnable() {
        unifiedProtection = new BukkitUnifiedProtection();
        SentryInitializer.initSentry("https://a5dfe8c79f9c3dad331ebdcb8923066a@o4505846670753792.ingest.sentry.io/4505846683992064", this);
        superheroes = this;
        this.hasSkillsLibrary = Bukkit.getPluginManager().isPluginEnabled("SkillsLibrary2");
        ConfigurationData.setup(this);
        foliaHacks = new FoliaHacks(this);
        this.saveDefaultConfig();
        this.configHandler = new ConfigHandler(this);
        this.heroHandler = new HeroHandler(this, this.configHandler);
        this.registerSkills();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        HeroCommand heroCommand = new HeroCommand(this.heroHandler);
        PluginCommand command = this.getCommand("hero");
        command.setExecutor((CommandExecutor)heroCommand);
        command.setTabCompleter((TabCompleter)heroCommand);
        this.handleMetrics();
        this.plusUltraAdvertisement();
        this.checkForNewUpdate();
        bukkitAudiences = BukkitAudiences.create((Plugin)this);
        if (this.hasSkillsLibrary) {
            this.runSkillsLibraryChanges();
        }
        this.handleAliases(heroCommand, command);
        this.registerUserInterfaces();
        this.handleWorldGuardCompatibility();
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent e) {
        this.configHandler.loadSuperheroes(this.heroHandler);
        this.rerollHandler = new RerollHandler();
        this.getServer().getPluginManager().registerEvents((Listener)this.rerollHandler, (Plugin)this);
        this.heroHandler.handlePlayerData();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        this.heroHandler.loadSuperheroPlayer(e.getPlayer());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        this.heroHandler.unloadSuperheroPlayer(e.getPlayer());
    }

    public void handleWorldGuardCompatibility() {
        try {
            Plugin worldguard = this.getServer().getPluginManager().getPlugin("WorldGuard");
            if (worldguard != null && worldguard.isEnabled()) {
                this.worldGuardSupport = new WorldGuardSupport();
                this.getServer().getPluginManager().registerEvents((Listener)this.worldGuardSupport, (Plugin)this);
            }
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().severe("Disabling WorldGuard compatibility...");
            e.printStackTrace();
        }
    }

    public void registerSkills() {
        SkillImplementation[] skills;
        for (SkillImplementation skill : skills = new SkillImplementation[]{new DamageModifierSkill(this.heroHandler), new FlightSkill(this.heroHandler), new AttributeSkill(this.heroHandler), new PotionEffectSkill(this.heroHandler), new InstantBreak(this.heroHandler), new LightSkill(this.heroHandler), new NoHungerSkill(this.heroHandler), new DamageResistanceSkill(this.heroHandler), new SlimeSkill(this.heroHandler), new SneakingPotionSkill(this.heroHandler), new EggLayerSkill(this.heroHandler), new WalkerSkill(this.heroHandler), new AuraSkill(this.heroHandler), new PickpocketSkill(this.heroHandler), new StrongmanSkill(this.heroHandler), new PhaseSkill(this.heroHandler), new SlamSkill(this.heroHandler), new EraserSkill(this.heroHandler), new CraftingSkill(this.heroHandler), new TeleportSkill(this.heroHandler), new SummonSkill(this.heroHandler), new DecoySkill(this.heroHandler), new PotionGifterSkill(this.heroHandler), new ConsumeSkill(this.heroHandler), new BlockRaySkill(this.heroHandler), new OHKOSkill(this.heroHandler), new RepulsionSkill(this.heroHandler), new CreeperSkill(this.heroHandler), new GiveItemSkill(this.heroHandler), new GunSkill(this.heroHandler), new SneakSkill(this.heroHandler), new ShieldSkill(this.heroHandler), new SpellSkill(this.heroHandler), new ThrowerSkill(this.heroHandler), new ConvertItemSkill(this.heroHandler), new ConvertBlockSkill(this.heroHandler), new RemoteDetonationSkill(this.heroHandler), new BlockDropsSkill(this.heroHandler), new ConvertDropsSkill(this.heroHandler), new LifestealSkill(this.heroHandler), new DamagePotionSkill(this.heroHandler), new WeatherDamageSkill(this.heroHandler), new HeartStealSkill(this.heroHandler), new KillPotionSkill(this.heroHandler), new ClimbSkill(this.heroHandler)}) {
            this.getServer().getPluginManager().registerEvents((Listener)skill, (Plugin)this);
        }
    }

    public void registerUserInterfaces() {
        this.getServer().getPluginManager().registerEvents((Listener)new ChestHandler(), (Plugin)this);
    }

    public void runSkillsLibraryChanges() {
        Conditions.register((String)"HERO", SuperheroCondition.class);
    }

    public void plusUltraAdvertisement() {
        Superheroes.getScheduling().globalRegionalScheduler().runAtFixedRate(() -> {
            if (Bukkit.getOnlinePlayers().size() > 25 && Bukkit.getPluginManager().getPlugin("SuperheroesPlusUltra") == null) {
                this.getLogger().info("This server has quite a few players online! You may benefit from my premium addon SuperheroesPlusUltra");
                this.getLogger().info("This plugin adds a few extra default heroes, unlocks new powers in existing heroes");
                this.getLogger().info("adds skins to many heroes, adds skript compatibility, and even lets you write CUSTOM skills for your heroes!");
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("superheroes.notify")) continue;
                    player.sendMessage("This server has quite a few players online! You may benefit from my premium addon SuperheroesPlusUltra");
                    player.sendMessage("This plugin adds a few extra default heroes, unlocks new powers in existing heroes");
                    player.sendMessage("adds skins to many heroes, adds skript compatibility, and even lets you write CUSTOM skills for your heroes!");
                }
            }
        }, 3000L, 469000L);
    }

    public void checkForNewUpdate() {
        UpdateChecker.init(this, 79766);
        Superheroes.getScheduling().globalRegionalScheduler().runAtFixedRate(() -> {
            if (UpdateChecker.isInitialized()) {
                UpdateChecker updateChecker = UpdateChecker.get();
                updateChecker.requestUpdateCheck().thenAccept(result -> {
                    if (result.requiresUpdate()) {
                        this.getLogger().warning("This server is still running " + this.getDescription().getVersion() + " of Superheroes");
                        this.getLogger().warning("The latest version is " + result.getNewestVersion());
                        this.getLogger().warning("Updating is important to ensure there are not any bugs or vulnerabilities.");
                        this.getLogger().warning("As well as ensuring your players have the best time when using the superheroes!");
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            if (!player.hasPermission("superheroes.notify")) continue;
                            player.sendMessage("This server is still running " + this.getDescription().getVersion() + " of Superheroes");
                            player.sendMessage("The latest version is " + result.getNewestVersion());
                            player.sendMessage("Updating is important to ensure there are not any bugs or vulnerabilities.");
                            player.sendMessage("As well as ensuring your players have the best time when using the superheroes!");
                        }
                    }
                });
            }
        }, 6000L, 432000L);
    }

    public void onDisable() {
        bukkitAudiences.close();
        superheroes.getHeroHandler().getHeroIOHandler().shutdown();
    }

    public void handleMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 8671);
        if (!metrics.isEnabled()) {
            this.getLogger().log(Level.WARNING, "[Superheroes] You have disabled bstats, this is very sad :(");
        }
        metrics.addCustomChart(new Metrics.AdvancedPie("players_using_each_superhero", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                String powerName = this.heroHandler.getSuperhero(player).getName();
                int currentCount = valueMap.getOrDefault(powerName, 0);
                valueMap.put(powerName, ++currentCount);
            }
            return valueMap;
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("players_using_each_skill", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                Collection<String> skills = this.heroHandler.getSuperhero(player).getSkills();
                for (String skill : skills) {
                    int currentCount = valueMap.getOrDefault(skill, 0);
                    valueMap.put(skill, ++currentCount);
                }
            }
            return valueMap;
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("superheroes_using_each_skill", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            for (Superhero superhero : Superheroes.getInstance().getHeroHandler().getNameToSuperhero().values()) {
                Collection<String> skills = superhero.getSkills();
                for (String skill : skills) {
                    int currentCount = valueMap.getOrDefault(skill, 0);
                    valueMap.put(skill, ++currentCount);
                }
            }
            return valueMap;
        }));
        metrics.addCustomChart(new Metrics.SimplePie("superheroes_plus_ultra_usage", () -> Bukkit.getPluginManager().getPlugin("SuperheroesPlusUltra") != null ? "Yes" : "No"));
        metrics.addCustomChart(new Metrics.SimplePie("has_worldguard", () -> Bukkit.getPluginManager().getPlugin("WorldGuard") != null ? "Yes" : "No"));
        metrics.addCustomChart(new Metrics.SimplePie("has_skillslibrary", () -> Bukkit.getPluginManager().getPlugin("SkillsLibrary2") != null ? "Yes" : "No"));
        metrics.addCustomChart(new Metrics.SimplePie("uses_mysql", () -> "MySQL".equalsIgnoreCase(ConfigHandler.getDatabaseYAML().database().getType()) ? "Yes" : "No"));
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public HeroHandler getHeroHandler() {
        return this.heroHandler;
    }

    public boolean hasSkillsLibrary() {
        return this.hasSkillsLibrary;
    }

    public boolean hasPlusUltra() {
        return Bukkit.getPluginManager().isPluginEnabled("SuperheroesPlusUltra");
    }

    public RerollHandler getRerollHandler() {
        return this.rerollHandler;
    }

    private void handleAliases(final HeroCommand heroCommand, PluginCommand command) {
        List<String> commandAliases = ConfigHandler.getConfigYAML().heroCommand().aliases();
        if (!commandAliases.isEmpty()) {
            BukkitCommand aliasCommand = new BukkitCommand(this, commandAliases.get(0)){

                public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
                    return heroCommand.onCommand(sender, (Command)this, commandLabel, args);
                }

                @NotNull
                public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
                    return heroCommand.onTabComplete(sender, (Command)this, alias, args);
                }
            };
            aliasCommand.setDescription(command.getDescription());
            aliasCommand.setAliases(commandAliases.subList(1, commandAliases.size()));
            CommandMap commandMap = foliaHacks.getMorePaperLib().commandRegistration().getServerCommandMap();
            commandMap.register("superheroes", (Command)aliasCommand);
        }
    }
}

