/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.commands;

import java.util.ArrayList;
import java.util.List;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.commands.CheckCommand;
import me.xemor.superheroes.commands.ExportCommand;
import me.xemor.superheroes.commands.GUICommand;
import me.xemor.superheroes.commands.ImportCommand;
import me.xemor.superheroes.commands.ReloadCommand;
import me.xemor.superheroes.commands.RemoveAttributesCommand;
import me.xemor.superheroes.commands.RerollCommand;
import me.xemor.superheroes.commands.SelectCommand;
import me.xemor.superheroes.commands.SubCommands;
import me.xemor.superheroes.data.ConfigHandler;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.kyori.adventure.audience.Audience;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class HeroCommand
implements CommandExecutor,
TabExecutor {
    private final ConfigHandler configHandler;
    private final SelectCommand selectCommand;
    private final ReloadCommand reloadCommand;
    private final ImportCommand importCommand;
    private final ExportCommand exportCommand;
    private final GUICommand guiCommand;
    private final CheckCommand checkCommand;
    private final RerollCommand rerollCommand = new RerollCommand();
    private final RemoveAttributesCommand removeAttributesCommand;

    public HeroCommand(HeroHandler heroHandler) {
        this.configHandler = heroHandler.getPlugin().getConfigHandler();
        this.reloadCommand = new ReloadCommand(heroHandler, this.configHandler);
        this.selectCommand = new SelectCommand(heroHandler, this.configHandler);
        this.importCommand = new ImportCommand();
        this.exportCommand = new ExportCommand();
        this.guiCommand = new GUICommand();
        this.checkCommand = new CheckCommand();
        this.removeAttributesCommand = new RemoveAttributesCommand();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        Audience audience = Superheroes.getBukkitAudiences().sender(sender);
        if (!sender.hasPermission("superheroes.hero")) {
            audience.sendMessage((Component)MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getNoPermission()));
            return true;
        }
        if (args.length >= 1) {
            SubCommands commandType;
            try {
                commandType = SubCommands.valueOf(args[0].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                audience.sendMessage(MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getInvalidCommandMessage(), (TagResolver)Placeholder.unparsed("player", sender.getName())));
                return true;
            }
            switch (commandType) {
                case SELECT: {
                    this.selectCommand.onCommand(sender, args);
                    break;
                }
                case RELOAD: {
                    this.reloadCommand.onCommand(sender, args);
                    break;
                }
                case REROLL: {
                    this.rerollCommand.onCommand(sender, args);
                    break;
                }
                case EXPORT: {
                    this.exportCommand.onCommand(sender, args);
                    break;
                }
                case IMPORT: {
                    this.importCommand.onCommand(sender, args);
                    break;
                }
                case CHECK: {
                    this.checkCommand.onCommand(sender, args);
                    break;
                }
                case REMOVEATTRIBUTES: {
                    this.removeAttributesCommand.onCommand(sender, args);
                    break;
                }
                case GUI: {
                    this.guiCommand.onCommand(sender, args);
                }
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        List<String> tabComplete;
        block14: {
            block13: {
                tabComplete = new ArrayList<String>();
                if (args.length != 1) break block13;
                for (SubCommands subCommandEnum : SubCommands.values()) {
                    String subCommandStr = subCommandEnum.toString().toLowerCase();
                    if (!subCommandStr.startsWith(args[0].toLowerCase())) continue;
                    tabComplete.add(subCommandStr);
                }
                break block14;
            }
            if (args.length <= 1) break block14;
            try {
                SubCommands subCommand = SubCommands.valueOf(args[0].toUpperCase());
                tabComplete = switch (subCommand) {
                    default -> throw new MatchException(null, null);
                    case SubCommands.SELECT -> this.selectCommand.tabComplete(sender, args);
                    case SubCommands.RELOAD -> this.reloadCommand.tabComplete(sender, args);
                    case SubCommands.REROLL -> this.rerollCommand.tabComplete(sender, args);
                    case SubCommands.EXPORT -> this.exportCommand.tabComplete(sender, args);
                    case SubCommands.IMPORT -> this.importCommand.tabComplete(sender, args);
                    case SubCommands.CHECK -> this.checkCommand.tabComplete(sender, args);
                    case SubCommands.GUI -> this.guiCommand.tabComplete(sender, args);
                    case SubCommands.REMOVEATTRIBUTES -> this.removeAttributesCommand.tabComplete(sender, args);
                };
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return tabComplete;
    }
}

