/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.commands;

import java.util.List;
import java.util.Map;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.commands.SubCommand;
import me.xemor.superheroes.data.ConfigHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.kyori.adventure.audience.Audience;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.xemor.superheroes.reroll.RerollGroup;
import me.xemor.superheroes.reroll.RerollHandler;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class RerollCommand
implements SubCommand,
Listener {
    @Override
    public void onCommand(CommandSender sender, String[] args) {
        Audience audience = Superheroes.getBukkitAudiences().sender(sender);
        if (sender.hasPermission("superheroes.hero.reroll")) {
            Player player;
            RerollHandler rerollHandler = Superheroes.getInstance().getRerollHandler();
            String rerollGroupName = args.length >= 2 ? args[1] : "default";
            if (!sender.hasPermission("superheroes.hero.reroll." + rerollGroupName)) {
                audience.sendMessage(MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getNoPermission(), (TagResolver)Placeholder.unparsed("player", sender.getName())));
                return;
            }
            RerollGroup rerollGroup = rerollHandler.getWeightedHeroes(rerollGroupName);
            if (rerollGroup == null) {
                audience.sendMessage(MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getInvalidRerollGroupMessage(), (TagResolver)Placeholder.unparsed("player", sender.getName())));
                return;
            }
            if (args.length >= 3) {
                player = Bukkit.getPlayer((String)args[2]);
                if (player == null) {
                    audience.sendMessage(MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getInvalidPlayerMessage(), (TagResolver)Placeholder.unparsed("player", sender.getName())));
                    return;
                }
            } else if (sender instanceof Player) {
                player = (Player)sender;
            } else {
                return;
            }
            Superheroes.getInstance().getHeroHandler().setHero(player, rerollGroup.chooseHero(player), true, PlayerChangedSuperheroEvent.Cause.REROLL);
        } else {
            audience.sendMessage((Component)MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getNoPermission()));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return Superheroes.getInstance().getRerollHandler().getIterator().stream().map(Map.Entry::getKey).toList();
        }
        return null;
    }
}

