/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.commands;

import java.util.ArrayList;
import java.util.List;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.commands.SubCommand;
import me.xemor.superheroes.data.ConfigHandler;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.data.SuperheroPlayer;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.kyori.adventure.audience.Audience;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SelectCommand
implements SubCommand {
    private final HeroHandler heroHandler;
    private final ConfigHandler configHandler;

    public SelectCommand(HeroHandler heroHandler, ConfigHandler configHandler) {
        this.heroHandler = heroHandler;
        this.configHandler = configHandler;
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        SuperheroPlayer superheroPlayer;
        Superhero power;
        Player player;
        Audience audience = Superheroes.getBukkitAudiences().sender(sender);
        if (!sender.hasPermission("superheroes.hero.select")) {
            audience.sendMessage(MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getNoPermission(), (TagResolver)Placeholder.unparsed("player", sender.getName())));
            return;
        }
        if (args.length <= 1) {
            if (sender instanceof Player) {
                player = (Player)sender;
                if (sender.hasPermission("superheroes.hero.gui")) {
                    this.heroHandler.openHeroGUI(player);
                    return;
                }
            }
            power = null;
        } else {
            power = this.heroHandler.getSuperhero(args[1].toLowerCase());
        }
        if (power == null) {
            audience.sendMessage(MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getInvalidHeroMessage(), Placeholder.unparsed("player", sender.getName()), Placeholder.unparsed("hero", args[1])));
            return;
        }
        if (!sender.hasPermission("superheroes.hero.select." + power.getName().toLowerCase()) && Superheroes.getInstance().getRerollHandler().getRerollConfig().getGlobalRerollSettings().doesEachHeroRequirePermissions()) {
            audience.sendMessage(MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getNoPermission(), (TagResolver)Placeholder.unparsed("player", sender.getName())));
            return;
        }
        if (sender instanceof Player) {
            Player senderPlayer = (Player)sender;
            superheroPlayer = this.heroHandler.getSuperheroPlayer(senderPlayer);
            if (!sender.hasPermission("superheroes.hero.select.bypasscooldown") && !superheroPlayer.handleCooldown(senderPlayer, audience)) {
                return;
            }
        }
        if (args.length >= 3 && sender.hasPermission("superheroes.hero.select.others")) {
            player = Bukkit.getPlayer((String)args[2]);
            if (player == null) {
                MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getInvalidPlayerMessage(), (TagResolver)Placeholder.unparsed("player", sender.getName()));
                return;
            }
        } else if (sender instanceof Player) {
            player = (Player)sender;
        } else {
            return;
        }
        this.heroHandler.setHero(player, power, true, PlayerChangedSuperheroEvent.Cause.COMMAND);
        superheroPlayer = this.heroHandler.getSuperheroPlayer(player);
        this.heroHandler.getHeroIOHandler().saveSuperheroPlayerAsync(superheroPlayer);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        ArrayList<String> heroesTabComplete = new ArrayList<String>();
        if (args.length == 2) {
            String secondArg = args[1];
            for (Superhero superhero : this.heroHandler.getNameToSuperhero().values()) {
                if (!superhero.getName().startsWith(secondArg) || !sender.hasPermission(superhero.getPermission())) continue;
                heroesTabComplete.add(superhero.getName());
            }
            return heroesTabComplete;
        }
        return null;
    }
}

