/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.xemor.superheroes.configurationdata.ConfigurationData;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AttributesData {
    @JsonProperty(value="attributes")
    private Map<Attribute, Double> attributes = new HashMap<Attribute, Double>();
    @JsonPropertyWithDefault
    private EquipmentSlotGroup equipmentSlot = EquipmentSlotGroup.ANY;
    @JsonPropertyWithDefault
    private Operation operation = Operation.MULTIPLY_SCALAR;
    @JsonProperty
    @JsonAlias(value={"unique_key"})
    private String uniqueKey;

    public AttributesData() {
    }

    @JsonIgnore
    public AttributesData(Map<Attribute, Double> attributes, EquipmentSlotGroup equipmentSlot, Operation operation, String uniqueKey) {
        this.attributes = attributes;
        if (equipmentSlot != null) {
            this.equipmentSlot = equipmentSlot;
        }
        if (operation != null) {
            this.operation = operation;
        }
        this.uniqueKey = uniqueKey;
    }

    public void applyAttributes(LivingEntity livingEntity) {
        for (Map.Entry<Attribute, Double> pair : this.attributes.entrySet()) {
            AttributeInstance instance;
            if (pair.getKey() == null) {
                ConfigurationData.getLogger().severe("null key in attributes when applying");
                ConfigurationData.getLogger().severe("valid attributes are: %s".formatted(Registry.ATTRIBUTE.stream().map(attr -> attr.getKey().getKey()).reduce((s1, s2) -> s1 + ", " + s2)));
                continue;
            }
            if (pair.getValue() == null) {
                ConfigurationData.getLogger().severe("null value in attributes when applying");
            }
            double value = pair.getValue();
            if (this.operation == Operation.MULTIPLY_SCALAR) {
                value -= 1.0;
            }
            if ((instance = livingEntity.getAttribute(pair.getKey())) == null) continue;
            AttributeModifier modifier = this.getMinorVersion() <= 20 ? new AttributeModifier(new UUID(this.uniqueKey.hashCode(), this.uniqueKey.hashCode()), this.uniqueKey, value, this.operation.getAttributeModifierOperation()) : new AttributeModifier(new NamespacedKey((Plugin)ConfigurationData.getPlugin(), this.uniqueKey), value, this.operation.getAttributeModifierOperation(), this.equipmentSlot);
            instance.addModifier(modifier);
        }
    }

    public void applyAttributes(ItemMeta itemMeta) {
        for (Map.Entry<Attribute, Double> pair : this.attributes.entrySet()) {
            double value = pair.getValue();
            if (this.operation == Operation.MULTIPLY_SCALAR) {
                value -= 1.0;
            }
            if (this.getMinorVersion() <= 20) {
                itemMeta.addAttributeModifier(pair.getKey(), new AttributeModifier(new UUID(this.uniqueKey.hashCode(), this.uniqueKey.hashCode()), this.uniqueKey, value, this.operation.getAttributeModifierOperation()));
                continue;
            }
            itemMeta.addAttributeModifier(pair.getKey(), new AttributeModifier(new NamespacedKey((Plugin)ConfigurationData.getPlugin(), this.uniqueKey), value, this.operation.getAttributeModifierOperation(), this.equipmentSlot));
        }
    }

    public int getMinorVersion() {
        return Integer.parseInt(Bukkit.getServer().getBukkitVersion().split("-")[0].split("\\.")[1]);
    }

    public void resetAttributes(LivingEntity livingEntity) {
        for (Map.Entry<Attribute, Double> pair : this.attributes.entrySet()) {
            AttributeInstance instance = livingEntity.getAttribute(pair.getKey());
            if (instance == null) continue;
            for (AttributeModifier modifier : instance.getModifiers()) {
                if (this.getMinorVersion() <= 20) {
                    if (!this.uniqueKey.equals(modifier.getName())) continue;
                    instance.removeModifier(modifier);
                    continue;
                }
                if (!this.uniqueKey.equalsIgnoreCase(modifier.getKey().getKey())) continue;
                instance.removeModifier(modifier);
            }
        }
    }

    public double getValue(LivingEntity livingEntity, Attribute attribute) {
        Double value = this.attributes.get(attribute);
        if (value == null) {
            return livingEntity.getAttribute(attribute).getBaseValue();
        }
        return value;
    }

    public static enum Operation {
        ADD_NUMBER,
        ADD_SCALAR,
        MULTIPLY_SCALAR_1,
        MULTIPLY_SCALAR;


        public AttributeModifier.Operation getAttributeModifierOperation() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> AttributeModifier.Operation.ADD_NUMBER;
                case 1 -> AttributeModifier.Operation.ADD_SCALAR;
                case 2, 3 -> AttributeModifier.Operation.MULTIPLY_SCALAR_1;
            };
        }
    }
}

