/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.logging.Logger;
import me.xemor.superheroes.configurationdata.deserializers.BlockDataDeserializer;
import me.xemor.superheroes.configurationdata.deserializers.BukkitVectorDeserializer;
import me.xemor.superheroes.configurationdata.deserializers.ColorDeserializer;
import me.xemor.superheroes.configurationdata.deserializers.EntityDataDeserializer;
import me.xemor.superheroes.configurationdata.deserializers.ItemStackDeserializer;
import me.xemor.superheroes.configurationdata.deserializers.text.ComponentDeserializer;
import me.xemor.superheroes.configurationdata.deserializers.text.RegistryDeserializer;
import me.xemor.superheroes.configurationdata.deserializers.text.RegistryKeyDeserializer;
import me.xemor.superheroes.configurationdata.entity.EntityData;
import me.xemor.superheroes.configurationdata.particles.shapes.Shapes;
import me.xemor.superheroes.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Vector;

public class ConfigurationData {
    private static Logger logger = Logger.getLogger("XemorConfiguration");
    private static JavaPlugin plugin;

    public static Logger getLogger() {
        return logger;
    }

    public static JavaPlugin getPlugin() {
        return plugin;
    }

    public static ObjectMapper setupObjectMapperForConfigurationData(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(Attribute.class, new RegistryDeserializer(Registry.ATTRIBUTE)).addDeserializer(Enchantment.class, new RegistryDeserializer(Registry.ENCHANTMENT)).addDeserializer(EntityType.class, new RegistryDeserializer(Registry.ENTITY_TYPE)).addDeserializer(Material.class, new RegistryDeserializer(Registry.MATERIAL)).addDeserializer(PotionEffectType.class, new RegistryDeserializer(Registry.EFFECT)).addDeserializer(PotionType.class, new RegistryDeserializer(Registry.POTION)).addDeserializer(Sound.class, new RegistryDeserializer(Registry.SOUNDS)).addDeserializer(TrimMaterial.class, new RegistryDeserializer(Registry.TRIM_MATERIAL)).addDeserializer(TrimPattern.class, new RegistryDeserializer(Registry.TRIM_PATTERN)).addDeserializer(Particle.class, new RegistryDeserializer(Registry.PARTICLE_TYPE)).addDeserializer(BlockData.class, (JsonDeserializer)new BlockDataDeserializer()).addDeserializer(Vector.class, (JsonDeserializer)new BukkitVectorDeserializer()).addDeserializer(ItemStack.class, (JsonDeserializer)new ItemStackDeserializer()).addDeserializer(EntityData.class, (JsonDeserializer)new EntityDataDeserializer()).addDeserializer(Component.class, (JsonDeserializer)new ComponentDeserializer()).addDeserializer(Color.class, (JsonDeserializer)new ColorDeserializer());
        simpleModule.addKeyDeserializer(Attribute.class, new RegistryKeyDeserializer(Registry.ATTRIBUTE)).addKeyDeserializer(Enchantment.class, new RegistryKeyDeserializer(Registry.ENCHANTMENT)).addKeyDeserializer(EntityType.class, new RegistryKeyDeserializer(Registry.ENTITY_TYPE)).addKeyDeserializer(Material.class, new RegistryKeyDeserializer(Registry.MATERIAL)).addKeyDeserializer(PotionEffectType.class, new RegistryKeyDeserializer(Registry.EFFECT)).addKeyDeserializer(PotionType.class, new RegistryKeyDeserializer(Registry.POTION)).addKeyDeserializer(Sound.class, new RegistryKeyDeserializer(Registry.SOUNDS)).addKeyDeserializer(TrimMaterial.class, new RegistryKeyDeserializer(Registry.TRIM_MATERIAL)).addKeyDeserializer(TrimPattern.class, new RegistryKeyDeserializer(Registry.TRIM_PATTERN)).addKeyDeserializer(Particle.class, new RegistryKeyDeserializer(Registry.PARTICLE_TYPE));
        objectMapper.registerModule((Module)simpleModule);
        objectMapper.registerSubtypes(Shapes.getNamedSubTypes());
        return objectMapper;
    }

    public static int getArbitraryClock() {
        return (int)Math.abs(System.currentTimeMillis() / 50L);
    }

    public static void setup(JavaPlugin newPlugin) {
        plugin = newPlugin;
    }
}

