/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata;

import com.fasterxml.jackson.annotation.JsonAlias;
import me.xemor.superheroes.configurationdata.EquipableData;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;

public class EquipmentData {
    @JsonPropertyWithDefault
    @JsonAlias(value={"helmet"})
    private EquipableData head = null;
    @JsonPropertyWithDefault
    @JsonAlias(value={"chestplate"})
    private EquipableData chest = null;
    @JsonPropertyWithDefault
    @JsonAlias(value={"leggings"})
    private EquipableData legs = null;
    @JsonPropertyWithDefault
    @JsonAlias(value={"boots"})
    private EquipableData feet = null;
    @JsonPropertyWithDefault
    @JsonAlias(value={"hand"})
    private EquipableData mainhand = null;
    @JsonPropertyWithDefault
    private EquipableData offhand = null;

    public EquipableData getHead() {
        return this.head;
    }

    public EquipableData getChest() {
        return this.chest;
    }

    public EquipableData getLegs() {
        return this.legs;
    }

    public EquipableData getFeet() {
        return this.feet;
    }

    public EquipableData getMainHand() {
        return this.mainhand;
    }

    public EquipableData getOffHand() {
        return this.offhand;
    }

    public final void applyEquipment(LivingEntity livingEntity) {
        EntityEquipment equipment = livingEntity.getEquipment();
        if (equipment == null) {
            return;
        }
        if (this.head != null) {
            equipment.setHelmet(this.head.item(), true);
            equipment.setHelmetDropChance(this.head.droprate());
        }
        if (this.chest != null) {
            equipment.setChestplate(this.chest.item(), true);
            equipment.setChestplateDropChance(this.chest.droprate());
        }
        if (this.legs != null) {
            equipment.setLeggings(this.legs.item(), true);
            equipment.setLeggingsDropChance(this.legs.droprate());
        }
        if (this.feet != null) {
            equipment.setBoots(this.feet.item(), true);
            equipment.setBootsDropChance(this.feet.droprate());
        }
        if (this.mainhand != null) {
            equipment.setItemInMainHand(this.mainhand.item(), true);
            equipment.setItemInMainHandDropChance(this.mainhand.droprate());
        }
        if (this.offhand != null) {
            equipment.setItemInOffHand(this.offhand.item(), true);
            equipment.setItemInOffHandDropChance(this.offhand.droprate());
        }
    }
}

