/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.xemor.superheroes.configurationdata.AttributesData;
import me.xemor.superheroes.configurationdata.BookData;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.LeatherArmorColor;
import me.xemor.superheroes.configurationdata.TrimData;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ItemMetaData {
    private static LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build();
    @JsonPropertyWithDefault
    private String displayName = null;
    @JsonPropertyWithDefault
    private List<String> lore = null;
    @JsonPropertyWithDefault
    private boolean isUnbreakable = false;
    @JsonPropertyWithDefault
    private int durability = 0;
    @JsonPropertyWithDefault
    private int customModelData = 0;
    @JsonPropertyWithDefault
    private AttributesData attributes = null;
    @JsonPropertyWithDefault
    private TrimData trim = null;
    @JsonPropertyWithDefault
    private List<ItemFlag> flags = new ArrayList<ItemFlag>();
    @JsonPropertyWithDefault
    private BookData book = null;
    @JsonPropertyWithDefault
    private LeatherArmorColor color = null;
    @JsonPropertyWithDefault
    private Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();

    public ItemMeta createItemMeta(Material material) {
        return this.applyToItemMeta(Bukkit.getItemFactory().getItemMeta(material));
    }

    public ItemMeta applyToItemMeta(ItemMeta baseMeta) {
        ItemMeta meta = baseMeta.clone();
        if (this.displayName != null) {
            Object component = MiniMessage.miniMessage().deserialize(this.displayName);
            meta.setDisplayName(legacySerializer.serialize((Component)component));
        }
        if (this.lore != null) {
            this.lore = this.lore.stream().map(string -> legacySerializer.serialize((Component)MiniMessage.miniMessage().deserialize(string))).collect(Collectors.toList());
            meta.setLore(this.lore);
        }
        meta.setUnbreakable(this.isUnbreakable);
        meta.setCustomModelData(Integer.valueOf(this.customModelData));
        if (this.attributes != null) {
            this.attributes.applyAttributes(meta);
        }
        if (!this.enchantments.isEmpty()) {
            this.applyEnchantments(meta);
        }
        if (this.trim != null) {
            this.trim.applyTrim(meta);
        }
        for (ItemFlag flag : this.flags) {
            meta.addItemFlags(new ItemFlag[]{flag});
        }
        if (this.durability != 0 && meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(this.durability);
        }
        if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherMeta = (LeatherArmorMeta)meta;
            if (this.color != null) {
                this.color.handleLeatherArmor(leatherMeta);
            }
        }
        if (meta instanceof BookMeta) {
            BookMeta bookMeta = (BookMeta)meta;
            if (this.book != null) {
                this.book.applyToBookMeta(bookMeta);
            }
        }
        return meta;
    }

    public void applyEnchantments(ItemMeta itemMeta) {
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            for (Map.Entry<Enchantment, Integer> item : this.enchantments.entrySet()) {
                enchantmentStorageMeta.addStoredEnchant(item.getKey(), item.getValue().intValue(), true);
            }
        } else {
            for (Map.Entry<Enchantment, Integer> item : this.enchantments.entrySet()) {
                itemMeta.addEnchant(item.getKey(), item.getValue().intValue(), true);
            }
        }
    }
}

